/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.config;

import cn.workde.core.base.properties.WorkdeAsyncProperties;
import cn.workde.core.base.properties.WorkdeProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@EnableScheduling
public class WorkdeExecutorConfiguration
extends AsyncConfigurerSupport {
    private WorkdeProperties workdeProperties;

    @Bean(name={"taskExecutor"})
    public Executor getAsyncExecutor() {
        WorkdeAsyncProperties workdeAsyncProperties = this.workdeProperties.getWorkdeAsyncProperties();
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(workdeAsyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(workdeAsyncProperties.getMaxPoolSize());
        executor.setQueueCapacity(workdeAsyncProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(workdeAsyncProperties.getKeepAliveSeconds());
        executor.setThreadNamePrefix("async-executor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }

    public WorkdeExecutorConfiguration(WorkdeProperties workdeProperties) {
        this.workdeProperties = workdeProperties;
    }
}

