/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.config;

import cn.workde.core.base.properties.WorkdeProperties;
import cn.workde.core.base.utils.SpringUtils;
import cn.workde.core.base.utils.jackson.JacksonObjectMapper;
import cn.workde.core.base.validation.Validator;
import cn.workde.core.boot.config.ExceptionHandlerConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={WorkdeProperties.class})
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
@Import(value={ExceptionHandlerConfig.class})
public class WorkdeAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WorkdeAutoConfiguration.class);
    private WorkdeProperties workdeProperties;

    @Bean
    @ConditionalOnMissingBean
    public Validator validator() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u6821\u9a8c\u5668\u3011Bean\uff1aValidator ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        return new Validator();
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringUtils.class})
    public SpringUtils springUtils() {
        return new SpringUtils();
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper jacksonObjectMapper() {
        return new JacksonObjectMapper();
    }

    public WorkdeAutoConfiguration(WorkdeProperties workdeProperties) {
        this.workdeProperties = workdeProperties;
    }
}

