/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.plugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookExtraInfo {
    private static final Logger log = LoggerFactory.getLogger(WebhookExtraInfo.class);
    private LinkedHashMap<String, String> machineInfoMap;
    private Properties gitProperties;
    private Cache<String, String> cache;

    public WebhookExtraInfo(long duration, TimeUnit unit) {
        this.init(duration, unit);
    }

    private void init(long duration, TimeUnit unit) {
        this.fillGitProperties();
        this.fillCache(duration, unit);
        this.fillMachineInfo();
    }

    private void fillMachineInfo() {
        this.machineInfoMap = new LinkedHashMap(6);
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.machineInfoMap.put("\u670d\u52a1\u5668\u540d\u79f0\uff1a", localHost.getHostName());
            this.machineInfoMap.put("\u670d\u52a1\u5668\u5730\u5740\uff1a", localHost.getHostAddress());
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6\u672c\u673aip\u5730\u5740\u5931\u8d25");
        }
    }

    private void fillCache(long duration, TimeUnit unit) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build();
    }

    public void fillGitProperties() {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("git.properties");){
            if (Objects.isNull(resourceAsStream)) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream, Charset.defaultCharset().name()));
            if (Objects.nonNull(bufferedReader)) {
                this.gitProperties = new Properties();
                this.gitProperties.load(bufferedReader);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LinkedHashMap<String, String> getMachineInfoMap() {
        return this.machineInfoMap;
    }

    public Properties getGitProperties() {
        return this.gitProperties;
    }

    public Cache<String, String> getCache() {
        return this.cache;
    }
}

