/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.executor;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.executor.BaseWebhookExecutor;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.request.DingTalkRequestBody;
import cn.woodwhales.common.webhook.model.response.DingTalkResponse;
import cn.woodwhales.common.webhook.model.response.ExecuteResponse;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkWebhookExecutor<RequestBody extends BaseWebhookRequestBody>
extends BaseWebhookExecutor<DingTalkRequestBody, DingTalkResponse> {
    private static final Logger log = LoggerFactory.getLogger(DingTalkWebhookExecutor.class);
    private static final int ERR_CODE_SUCCESS = 0;

    @Override
    protected WebhookProductEnum webhookProductEnum() {
        return WebhookProductEnum.DING_TALK;
    }

    @Override
    protected boolean checkResponseObjectHandler(ExecuteResponse<DingTalkResponse> executeResponse) {
        DingTalkResponse dingTalkResponse = (DingTalkResponse)executeResponse.parsedResponseObject;
        return Objects.equals(0, dingTalkResponse.getErrcode());
    }

    public static <RequestBody extends BaseWebhookRequestBody> DingTalkWebhookExecutor<RequestBody> newInstance() {
        return new DingTalkWebhookExecutor<RequestBody>();
    }
}

