/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util.datasource;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.example.model.util.datasource.DataSourceIgnore;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTool {
    private static final Logger log = LoggerFactory.getLogger(DataSourceTool.class);
    private String driverClass;
    private String url;
    private String username;
    private String password;
    private Connection connection;
    private Map<Class, LinkedHashMap<Field, ColumnDict>> dbColumnMapping = new HashMap<Class, LinkedHashMap<Field, ColumnDict>>(16);

    public static DataSourceTool newMysql(String url, String username, String password) {
        return new DataSourceTool("com.mysql.jdbc.Driver", url, username, password);
    }

    public static DataSourceTool newMysql8(String url, String username, String password) {
        return new DataSourceTool("com.mysql.cj.jdbc.Driver", url, username, password);
    }

    public static DataSourceTool newOracle(String url, String username, String password) {
        return new DataSourceTool("oracle.jdbc.OracleDriver", url, username, password);
    }

    public static String wrappedField(Object object) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        if (Objects.isNull(object)) {
            sb.append("NULL");
        } else {
            sb.append(object);
        }
        sb.append("'");
        return sb.toString();
    }

    public static String formatSql(String sql, Object ... args) {
        if (Objects.isNull(args)) {
            return sql;
        }
        ArrayList<String> wrappedArgs = new ArrayList<String>(args.length);
        for (Object arg : args) {
            wrappedArgs.add(DataSourceTool.wrappedField(arg));
        }
        return DataSourceTool.format(sql, wrappedArgs.toArray());
    }

    private static String format(String messagePattern, Object[] argArray) {
        if (messagePattern == null) {
            return null;
        }
        if (argArray == null) {
            return messagePattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int L = 0; L < argArray.length; ++L) {
            int j = messagePattern.indexOf("{}", i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern, i, messagePattern.length());
                return sbuf.toString();
            }
            if (DataSourceTool.isEscapedDelimeter(messagePattern, j)) {
                if (!DataSourceTool.isDoubleEscaped(messagePattern, j)) {
                    --L;
                    sbuf.append(messagePattern, i, j - 1);
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern, i, j - 1);
                DataSourceTool.deeplyAppendParameter(sbuf, argArray[L], new HashMap<Object[], Object>());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern, i, j);
            DataSourceTool.deeplyAppendParameter(sbuf, argArray[L], new HashMap<Object[], Object>());
            i = j + 2;
        }
        sbuf.append(messagePattern, i, messagePattern.length());
        return sbuf.toString();
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map<Object[], Object> seenMap) {
        if (o == null) {
            sbuf.append("null");
        } else if (!o.getClass().isArray()) {
            DataSourceTool.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            DataSourceTool.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            DataSourceTool.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            DataSourceTool.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            DataSourceTool.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            DataSourceTool.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            DataSourceTool.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            DataSourceTool.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            DataSourceTool.doubleArrayAppend(sbuf, (double[])o);
        } else {
            DataSourceTool.objectArrayAppend(sbuf, (Object[])o, seenMap);
        }
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                DataSourceTool.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable var3) {
            sbuf.append("Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
        }
    }

    private static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    public DataSourceTool(String driverClass, String url, String username, String password) {
        this.driverClass = driverClass;
        this.url = url;
        this.username = username;
        this.password = password;
        try {
            Connection connection;
            Class.forName(this.driverClass);
            this.connection = connection = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                SQLException sqlException = (SQLException)cause;
                String sqlState = sqlException.getSQLState();
                if ("28000".equals(sqlState)) {
                    log.error("\u6570\u636e\u5e93\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!!!");
                    System.err.println("\u6570\u636e\u5e93\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!!!");
                }
            } else {
                log.error("\u94fe\u63a5\u6570\u636e\u5e93\u5931\u8d25, cause by = {}", (Object)e.getMessage(), (Object)e);
                System.out.println("cause by = = " + e.getMessage());
            }
            System.exit(0);
        }
    }

    public <T> List<T> queryList(String sql, Class<T> clazz) throws Exception {
        return this.queryList(sql, resultSet -> this.cacheDbColumnMapping(clazz, (ResultSet)resultSet), resultSet -> this.getDataFromResultSet(clazz, (ResultSet)resultSet));
    }

    private <T> List<Field> getNeedFillFieldList(Class<T> clazz) {
        ArrayList<Field> needFillFieldList = null;
        Field[] declaredFields = FieldUtils.getAllFields(clazz);
        needFillFieldList = new ArrayList<Field>(declaredFields.length);
        for (Field field : declaredFields) {
            if (!Objects.isNull(field.getAnnotation(DataSourceIgnore.class))) continue;
            needFillFieldList.add(field);
        }
        return needFillFieldList;
    }

    private void cacheDbColumnMapping(Class<?> clazz, ResultSet resultSet) {
        List<Field> fieldList = this.getNeedFillFieldList(clazz);
        List<ColumnDict> dbColumnDictList = this.getDbColumnDictList(resultSet);
        this.dbColumnMapping.put(clazz, this.dbColumnMap(fieldList, dbColumnDictList));
    }

    private List<ColumnDict> getDbColumnDictList(ResultSet resultSet) {
        ArrayList<ColumnDict> dbColumnDictList = new ArrayList<ColumnDict>();
        ResultSetMetaData metaData = this.getMetaData(resultSet);
        int columnCount = this.getColumnCount(metaData);
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            String columnName = this.getColumnName(metaData, columnIndex);
            String columnTypeName = this.getColumnTypeName(metaData, columnIndex);
            dbColumnDictList.add(new ColumnDict(columnIndex, columnName, columnTypeName));
        }
        return dbColumnDictList;
    }

    private LinkedHashMap<Field, ColumnDict> dbColumnMap(List<Field> fieldList, List<ColumnDict> dbColumnDictList) {
        Map<String, ColumnDict> dbColumnDictMap = DataTool.toMap(dbColumnDictList, ColumnDict::getColumnName);
        LinkedHashMap<Field, ColumnDict> result = new LinkedHashMap<Field, ColumnDict>();
        for (Field field : fieldList) {
            String name = field.getName();
            if (dbColumnDictMap.containsKey(name)) {
                result.put(field, dbColumnDictMap.get(name));
                continue;
            }
            String convertName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
            if (!dbColumnDictMap.containsKey(convertName)) continue;
            result.put(field, dbColumnDictMap.get(convertName));
        }
        return result;
    }

    public String getColumnTypeName(ResultSetMetaData metaData, int columnIndex) {
        String columnTypeName = null;
        try {
            columnTypeName = metaData.getColumnTypeName(columnIndex);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnTypeName;
    }

    public String getColumnName(ResultSetMetaData metaData, int columnIndex) {
        String columnName = null;
        try {
            columnName = metaData.getColumnLabel(columnIndex);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnName;
    }

    public int getColumnCount(ResultSetMetaData metaData) {
        int columnCount = 0;
        try {
            columnCount = metaData.getColumnCount();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnCount;
    }

    public ResultSetMetaData getMetaData(ResultSet resultSet) {
        ResultSetMetaData metaData = null;
        try {
            metaData = resultSet.getMetaData();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return metaData;
    }

    public <T> T queryOne(String sql, Class<T> clazz) throws Exception {
        return (T)this.queryOne(sql, resultSet -> this.cacheDbColumnMapping(clazz, (ResultSet)resultSet), resultSet -> this.getDataFromResultSet(clazz, (ResultSet)resultSet));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql) {
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getDataFromResultSet(Class<T> clazz, ResultSet resultSet) {
        T target = null;
        try {
            target = clazz.newInstance();
            LinkedHashMap<Field, ColumnDict> fieldHashMap = this.dbColumnMapping.get(clazz);
            if (!MapUtils.isNotEmpty(fieldHashMap)) return target;
            for (Map.Entry<Field, ColumnDict> entry : fieldHashMap.entrySet()) {
                Field field = entry.getKey();
                try {
                    Object object = this.getObject(resultSet, field, entry.getValue());
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    field.set(target, object);
                    field.setAccessible(accessible);
                }
                catch (IllegalAccessException | SQLException e) {
                    throw new RuntimeException(String.format("cause by = %s, fieldName=%s, fieldType=%s, ColumnDict = %s", e.getMessage(), field.getName(), field.getType().getName(), entry.getValue()));
                    return target;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    private Object getObject(ResultSet resultSet, Field field, ColumnDict columnDict) throws SQLException {
        Timestamp timestamp;
        Class<Object> type = field.getType();
        Object object = null;
        if (type.isAssignableFrom(String.class)) {
            object = resultSet.getString(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) {
            object = resultSet.getInt(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.class)) {
            object = resultSet.getBoolean(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.class)) {
            object = resultSet.getBoolean(columnDict.columnIndex);
        } else if (type.isAssignableFrom(BigDecimal.class)) {
            object = resultSet.getBigDecimal(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE)) {
            object = resultSet.getLong(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE)) {
            object = resultSet.getByte(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE)) {
            object = resultSet.getByte(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE)) {
            object = resultSet.getByte(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE)) {
            object = resultSet.getShort(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Byte[].class) || type.isAssignableFrom(byte[].class)) {
            object = resultSet.getBytes(columnDict.columnIndex);
        } else if (type.isAssignableFrom(Date.class)) {
            Timestamp timestamp2 = resultSet.getTimestamp(columnDict.columnIndex);
            if (Objects.nonNull(timestamp2)) {
                object = new Date(timestamp2.getTime());
            }
        } else if (type.isAssignableFrom(LocalDateTime.class)) {
            Timestamp timestamp3 = resultSet.getTimestamp(columnDict.columnIndex);
            if (Objects.nonNull(timestamp3)) {
                object = timestamp3.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
        } else if (type.isAssignableFrom(LocalDate.class)) {
            Timestamp timestamp4 = resultSet.getTimestamp(columnDict.columnIndex);
            if (Objects.nonNull(timestamp4)) {
                object = timestamp4.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
        } else if (type.isAssignableFrom(LocalTime.class) && Objects.nonNull(timestamp = resultSet.getTimestamp(columnDict.columnIndex))) {
            object = timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        }
        return object;
    }

    public <T> List<T> queryList(String sql, Function<ResultSet, T> function) throws Exception {
        return this.queryList(sql, null, function);
    }

    public <T> List<T> queryList(String sql, Consumer<ResultSet> resultSetConsumer, Function<ResultSet, T> function) throws Exception {
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery(sql);
        if (Objects.nonNull(resultSetConsumer)) {
            resultSetConsumer.accept(rs);
        }
        ArrayList<T> dataList = new ArrayList<T>();
        while (rs.next()) {
            T data = function.apply(rs);
            dataList.add(data);
        }
        rs.close();
        statement.close();
        return dataList;
    }

    public <T> T queryOne(String sql, Function<ResultSet, T> function) throws Exception {
        return this.queryOne(sql, null, function);
    }

    /*
     * Exception decompiling
     */
    public <T> T queryOne(String sql, Consumer<ResultSet> resultSetConsumer, Function<ResultSet, T> function) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DataSourceTool() {
    }

    private static class ColumnDict {
        public int columnIndex;
        public String columnName;
        public String columnTypeName;

        public ColumnDict(int columnIndex, String columnName, String columnTypeName) {
            this.columnIndex = columnIndex;
            this.columnName = columnName;
            this.columnTypeName = columnTypeName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String toString() {
            return "DataSourceTool.ColumnDict(columnIndex=" + this.columnIndex + ", columnName=" + this.getColumnName() + ", columnTypeName=" + this.columnTypeName + ")";
        }
    }
}

