/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomExtractor {
    private static final Logger log = LoggerFactory.getLogger(RandomExtractor.class);

    public static <T> List<T> randomDrawWithRate(List<T> dataList, double randomDrawRate) {
        if (randomDrawRate < 0.0 || randomDrawRate > 1.0) {
            throw new IllegalArgumentException("\u6982\u7387\u503c\u4e0d\u5728 0 \u81f3 1 \u4e4b\u95f4");
        }
        int randomDrawCount = (int)((double)CollectionUtils.size(dataList) * randomDrawRate);
        return RandomExtractor.randomDrawWithCount(dataList, randomDrawCount);
    }

    private static <T> List<T> randomDrawProcess(List<T> dataList, int randomDrawCount) {
        int resultSize;
        if (randomDrawCount < 0) {
            throw new IllegalArgumentException("\u968f\u673a\u603b\u91cf\u4e0d\u80fd\u5c0f\u4e8e 0");
        }
        ArrayList<T> result = new ArrayList<T>();
        if (CollectionUtils.isEmpty(dataList) || Objects.equals(randomDrawCount, 0)) {
            return result;
        }
        int dataListSize = CollectionUtils.size(dataList);
        if (randomDrawCount > dataListSize) {
            log.warn("randomDrawCount={} > dataListSize ={}, \u53ea\u83b7\u53d6 {} \u4e2a\u5143\u7d20", new Object[]{randomDrawCount, dataListSize, dataListSize});
            resultSize = dataListSize;
        } else {
            resultSize = randomDrawCount;
        }
        List<Integer> randomIndexList = RandomExtractor.randomIndexList(dataList.size());
        for (int i = 0; i < resultSize; ++i) {
            int index = randomIndexList.get(i);
            result.add(dataList.get(index));
        }
        return result;
    }

    public static <T> List<T> randomDrawWithCount(List<T> dataList, Integer randomDrawCount) {
        return RandomExtractor.randomDrawProcess(dataList, randomDrawCount);
    }

    private static List<Integer> randomIndexList(Integer initSize) {
        ArrayList<Integer> indexList = new ArrayList<Integer>(initSize);
        for (int i = 0; i < initSize; ++i) {
            indexList.add(i);
        }
        Collections.shuffle(indexList);
        return indexList;
    }
}

