/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.mybatisplus;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.model.field.PageQueryInterface;
import cn.woodwhales.common.model.param.SimplePageQueryParam;
import cn.woodwhales.common.model.vo.PageRespVO;
import cn.woodwhales.common.model.vo.RespVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public class MybatisPlusExecutor {
    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> List<DTO> list(Mapper mapper, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping) {
        List entityList = mapper.selectList(wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList();
        }
        return DataTool.toList(entityList, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> List<DTO> list(ServiceImpl<Mapper, Entity> service, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping) {
        List entityList = service.list(wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList();
        }
        return DataTool.toList(entityList, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> List<DTO> list(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        return MybatisPlusExecutor.list(mapper, wrapper, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> List<DTO> list(ServiceImpl<Mapper, Entity> service, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        return MybatisPlusExecutor.list(service, wrapper, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> List<Entity> list(Mapper mapper, Wrapper<Entity> wrapper) {
        List entityList = mapper.selectList(wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList();
        }
        return entityList;
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> List<Entity> list(ServiceImpl<Mapper, Entity> service, Wrapper<Entity> wrapper) {
        List entityList = service.list(wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList();
        }
        return entityList;
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> List<Entity> list(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return MybatisPlusExecutor.list(mapper, wrapper);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> List<Entity> list(ServiceImpl<Mapper, Entity> service, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return MybatisPlusExecutor.list(service, wrapper);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO, Key> Map<Key, DTO> list(Mapper mapper, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping, Function<? super DTO, ? extends Key> keyMapping) {
        return DataTool.toMap(MybatisPlusExecutor.list(mapper, wrapper, mapping), keyMapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO, Key> Map<Key, DTO> listMap(ServiceImpl<Mapper, Entity> service, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping, Function<? super DTO, ? extends Key> keyMapping) {
        return DataTool.toMap(MybatisPlusExecutor.list(service, wrapper, mapping), keyMapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO, Key> Map<Key, DTO> list(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping, Function<? super DTO, ? extends Key> keyMapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return DataTool.toMap(MybatisPlusExecutor.list(mapper, wrapper, mapping), keyMapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO, Key> Map<Key, DTO> listMap(ServiceImpl<Mapper, Entity> service, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping, Function<? super DTO, ? extends Key> keyMapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return DataTool.toMap(MybatisPlusExecutor.list(service, wrapper, mapping), keyMapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> DTO one(Mapper mapper, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping) {
        Object entity = mapper.selectOne(wrapper);
        if (Objects.isNull(entity)) {
            return null;
        }
        return mapping.apply(entity);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> DTO one(ServiceImpl<Mapper, Entity> service, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping) {
        Object entity = service.getOne(wrapper);
        if (Objects.isNull(entity)) {
            return null;
        }
        return mapping.apply(entity);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> DTO one(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return MybatisPlusExecutor.one(mapper, lambdaQueryWrapperConsumer, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> DTO one(ServiceImpl<Mapper, Entity> service, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return MybatisPlusExecutor.one(service, lambdaQueryWrapperConsumer, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> Entity one(Mapper mapper, Wrapper<Entity> wrapper) {
        Object entity = mapper.selectOne(wrapper);
        if (Objects.isNull(entity)) {
            return null;
        }
        return (Entity)entity;
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> Entity one(ServiceImpl<Mapper, Entity> service, Wrapper<Entity> wrapper) {
        Object entity = service.getOne(wrapper);
        if (Objects.isNull(entity)) {
            return null;
        }
        return (Entity)entity;
    }

    public static <Entity, DTO, Mapper extends BaseMapper<Entity>> RespVO<PageRespVO<DTO>> page(Mapper mapper, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<Entity, DTO> mapping) {
        return PageRespVO.buildPageRespVO(MybatisPlusExecutor.pageEntity(mapper, queryParam, lambdaQueryWrapperConsumer), mapping);
    }

    public static <E, Param, Mapper extends BaseMapper<E>, Service extends ServiceImpl<Mapper, E>> RespVO<PageRespVO<E>> page(Service service, SimplePageQueryParam<Param> queryParam, Consumer<LambdaQueryWrapper<E>> lambdaQueryWrapperConsumer) {
        return MybatisPlusExecutor.page(service, (PageQueryInterface)queryParam.getPageQueryParam(), lambdaQueryWrapperConsumer);
    }

    public static <E, Param, Mapper extends BaseMapper<E>> RespVO<PageRespVO<E>> page(Mapper mapper, SimplePageQueryParam<Param> queryParam, Consumer<LambdaQueryWrapper<E>> lambdaQueryWrapperConsumer) {
        return MybatisPlusExecutor.page(mapper, (PageQueryInterface)queryParam.getPageQueryParam(), lambdaQueryWrapperConsumer);
    }

    public static <V, E, Param, Mapper extends BaseMapper<E>, Service extends ServiceImpl<Mapper, E>> RespVO<PageRespVO<V>> page(Service service, SimplePageQueryParam<Param> queryParam, Consumer<LambdaQueryWrapper<E>> lambdaQueryWrapperConsumer, Function<E, V> function) {
        return MybatisPlusExecutor.page(service, (PageQueryInterface)queryParam.getPageQueryParam(), lambdaQueryWrapperConsumer, function);
    }

    public static <V, E, Param, Mapper extends BaseMapper<E>> RespVO<PageRespVO<V>> page(Mapper mapper, SimplePageQueryParam<Param> queryParam, Consumer<LambdaQueryWrapper<E>> lambdaQueryWrapperConsumer, Function<E, V> function) {
        return MybatisPlusExecutor.page(mapper, (PageQueryInterface)queryParam.getPageQueryParam(), lambdaQueryWrapperConsumer, function);
    }

    public static <Entity, DTO, Mapper extends BaseMapper<Entity>> RespVO<PageRespVO<DTO>> page(ServiceImpl<Mapper, Entity> service, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<Entity, DTO> mapping) {
        if (Objects.isNull(mapping)) {
            throw new IllegalArgumentException("mapping\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return PageRespVO.buildPageRespVO(MybatisPlusExecutor.pageEntity(service, queryParam, lambdaQueryWrapperConsumer), mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> RespVO<PageRespVO<Entity>> page(Mapper mapper, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        return PageRespVO.buildPageRespVO(MybatisPlusExecutor.pageEntity(mapper, queryParam, lambdaQueryWrapperConsumer));
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> RespVO<PageRespVO<Entity>> page(ServiceImpl<Mapper, Entity> service, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        return PageRespVO.buildPageRespVO(MybatisPlusExecutor.pageEntity(service, queryParam, lambdaQueryWrapperConsumer));
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> Page<Entity> pageEntity(Mapper mapper, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        Page page = new Page((long)queryParam.getPage().intValue(), (long)queryParam.getLimit().intValue());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return (Page)mapper.selectPage((IPage)page, (Wrapper)wrapper);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> Page<Entity> pageEntity(ServiceImpl<Mapper, Entity> service, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        Page page = new Page((long)queryParam.getPage().intValue(), (long)queryParam.getLimit().intValue());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return (Page)service.page((IPage)page, (Wrapper)wrapper);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> RespVO<PageRespVO<Entity>> page(Mapper mapper, PageQueryInterface queryParam, Wrapper<Entity> wrapper) {
        Page page = new Page((long)queryParam.getPage().intValue(), (long)queryParam.getLimit().intValue());
        IPage pageResult = mapper.selectPage((IPage)page, wrapper);
        return PageRespVO.buildPageRespVO(pageResult);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> RespVO<PageRespVO<Entity>> page(ServiceImpl<Mapper, Entity> service, PageQueryInterface queryParam, Wrapper<Entity> wrapper) {
        Page page = new Page((long)queryParam.getPage().intValue(), (long)queryParam.getLimit().intValue());
        IPage pageResult = service.page((IPage)page, wrapper);
        return PageRespVO.buildPageRespVO(pageResult);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> int insert(Mapper mapper, Entity entity) {
        if (Objects.nonNull(entity)) {
            return mapper.insert(entity);
        }
        return -1;
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> boolean insert(ServiceImpl<Mapper, Entity> service, Entity entity) {
        if (Objects.nonNull(entity)) {
            return service.save(entity);
        }
        return true;
    }

    public static <Mapper extends BaseMapper<Entity>, Entity> boolean batchInsert(ServiceImpl<Mapper, Entity> batchMapper, List<Entity> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return true;
        }
        return batchMapper.saveBatch(entityList);
    }

    public static <Mapper extends BaseMapper<Entity>, Entity, DTO> boolean batchInsert(ServiceImpl<Mapper, Entity> batchMapper, Function<List<DTO>, List<Entity>> mapping, List<DTO> dtoList) {
        List<Entity> entityList = mapping.apply(dtoList);
        if (CollectionUtils.isEmpty(entityList)) {
            return true;
        }
        return batchMapper.saveBatch(entityList);
    }

    public static <Mapper extends BaseMapper<Entity>, Entity, K extends Serializable> int update(Mapper mapper, Entity entity, Function<Entity, K> entityIdFunction, Function<Entity, Entity> function) {
        Object entityFromDB = mapper.selectById((Serializable)entityIdFunction.apply(entity));
        if (Objects.isNull(entityFromDB)) {
            return 0;
        }
        return mapper.updateById(function.apply(entityFromDB));
    }
}

