/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.model.result;

import cn.woodwhales.common.model.enums.RespCodeEnum;
import cn.woodwhales.common.model.result.BaseRespResult;
import java.util.Objects;

public class OpResult<T> {
    private BaseRespResult baseRespResult;
    private T data;

    public static <T> OpResult<T> success(T data) {
        return new OpResult<T>(RespCodeEnum.SUCCESS, data);
    }

    public static <T> OpResult<T> success() {
        return new OpResult<Object>(RespCodeEnum.SUCCESS, null);
    }

    public static <T> OpResult<T> failure() {
        return new OpResult<Object>(RespCodeEnum.ERROR, null);
    }

    public static <T> OpResult<T> failure(BaseRespResult baseRespResult) {
        return new OpResult<Object>(baseRespResult, null);
    }

    public static <T> OpResult<T> failure(BaseRespResult baseRespResult, T data) {
        return new OpResult<T>(baseRespResult, data);
    }

    public static <T> OpResult<T> error(final String errorMsg) {
        return new OpResult<Object>(new BaseRespResult(){

            @Override
            public String getMessage() {
                return errorMsg;
            }

            @Override
            public Integer getCode() {
                return RespCodeEnum.ERROR.getCode();
            }
        }, null);
    }

    public static <T> OpResult<T> error(final Integer errorCode, final String errorMsg) {
        return new OpResult<Object>(new BaseRespResult(){

            @Override
            public String getMessage() {
                return errorMsg;
            }

            @Override
            public Integer getCode() {
                return errorCode;
            }
        }, null);
    }

    public T getData() {
        return this.data;
    }

    public BaseRespResult getBaseRespResult() {
        return this.baseRespResult;
    }

    public boolean dataIsNull() {
        return Objects.isNull(this.data);
    }

    public boolean dataIsNonNull() {
        return Objects.nonNull(this.data);
    }

    public boolean isSuccessful() {
        return Objects.equals(this.baseRespResult.getCode(), RespCodeEnum.SUCCESS.getCode());
    }

    public boolean isFailure() {
        return !this.isSuccessful();
    }

    private OpResult() {
    }

    private OpResult(BaseRespResult baseRespResult, T data) {
        this.baseRespResult = baseRespResult;
        this.data = data;
    }

    public void setBaseRespResult(BaseRespResult baseRespResult) {
        this.baseRespResult = baseRespResult;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpResult)) {
            return false;
        }
        OpResult other = (OpResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseRespResult this$baseRespResult = this.getBaseRespResult();
        BaseRespResult other$baseRespResult = other.getBaseRespResult();
        if (this$baseRespResult == null ? other$baseRespResult != null : !this$baseRespResult.equals(other$baseRespResult)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseRespResult $baseRespResult = this.getBaseRespResult();
        result = result * 59 + ($baseRespResult == null ? 43 : $baseRespResult.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "OpResult(baseRespResult=" + this.getBaseRespResult() + ", data=" + this.getData() + ")";
    }
}

