/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.relation.service;

import cn.woodwhales.common.example.relation.entity.OrderEntity;
import cn.woodwhales.common.example.relation.entity.RoleEntity;
import cn.woodwhales.common.example.relation.entity.UserEntity;
import cn.woodwhales.common.example.relation.entity.UserRoleEntity;
import cn.woodwhales.common.example.relation.mapper.UserMapper;
import cn.woodwhales.common.example.relation.service.OrderServiceImpl;
import cn.woodwhales.common.example.relation.service.RoleServiceImpl;
import cn.woodwhales.common.example.relation.service.UserRoleServiceImpl;
import cn.woodwhales.common.mybatisplus.MybatisPlusRelationExecutor;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends ServiceImpl<UserMapper, UserEntity> {
    @Autowired
    private RoleServiceImpl roleService;
    @Autowired
    private UserRoleServiceImpl userRoleService;
    @Autowired
    private OrderServiceImpl orderService;

    public List<RoleEntity> getRoleListByUserId(Long userId) {
        return MybatisPlusRelationExecutor.executeQuery(userId, this, UserEntity::getId, this.userRoleService, UserRoleEntity::getUserId, UserRoleEntity::getRoleId, this.roleService, RoleEntity::getId);
    }

    public List<OrderEntity> getOrderListByUserId(Long userId) {
        return MybatisPlusRelationExecutor.executeQuery(userId, this, UserEntity::getId, this.orderService, OrderEntity::getUserId);
    }
}

