/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.business;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.business.DeduplicateResult;
import cn.woodwhales.common.example.model.business.DataToolTempData;
import cn.woodwhales.common.example.model.business.DataToolTempDataDTO;
import cn.woodwhales.common.example.model.business.DataToolTempEnum;
import cn.woodwhales.common.example.model.business.DataToolTempHandleMapDTO;
import cn.woodwhales.common.example.model.business.DataToolTempListData3;
import cn.woodwhales.common.example.model.business.DataToolTempListResult;
import cn.woodwhales.common.example.model.business.DataToolTempMapData1;
import cn.woodwhales.common.example.model.business.DataToolTempMapData2;
import cn.woodwhales.common.example.model.business.MyEnum;
import cn.woodwhales.common.example.model.business.example.UserDetailDTO;
import cn.woodwhales.common.example.model.business.example.UserDetailDTO2;
import cn.woodwhales.common.example.model.business.example.UserExtraInfoDTO;
import cn.woodwhales.common.example.model.business.example.UserExtraInfoDTO2;
import cn.woodwhales.common.example.model.business.example.UserInfoDTO;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataToolExample {
    public static void main(String[] args) {
        DataToolExample.testEnumGroupingBy();
    }

    public static void enumMap1() {
        Map<Integer, DataToolTempEnum> map = DataTool.enumMap(DataToolTempEnum.class, DataToolTempEnum::getCode);
        DataToolExample.assertEquals(3, map.size());
        DataToolExample.printMap(map);
        boolean containsKey = DataTool.enumContainsKey(1, DataToolTempEnum.class, DataToolTempEnum::getCode);
        DataToolExample.assertEquals(true, containsKey);
        DataToolTempEnum DataToolTempEnum2 = DataTool.enumGetValue(2, DataToolTempEnum.class, DataToolTempEnum::getCode);
        DataToolExample.assertEquals((Object)DataToolTempEnum.YELLOW, (Object)DataToolTempEnum2);
        DataToolTempEnum DataToolTempEnum22 = DataTool.enumGetValue(4, DataToolTempEnum.class, DataToolTempEnum::getCode);
        DataToolExample.assertNull((Object)DataToolTempEnum22);
    }

    public static void enumMap2() {
        Map<String, DataToolTempEnum> map = DataTool.enumMap(DataToolTempEnum.class);
        DataToolExample.assertEquals(3, map.size());
        DataToolExample.printMap(map);
    }

    public static void toMap2() {
        ArrayList<DataToolTempData> list = new ArrayList<DataToolTempData>();
        list.add(new DataToolTempData(1, "\u5f20\u4e09", "\u63cf\u8ff0-\u5f20\u4e09"));
        DataToolTempData DataToolTempData1 = new DataToolTempData(2, "\u674e\u56db", "\u63cf\u8ff0-\u674e\u56db");
        list.add(DataToolTempData1);
        DataToolTempData DataToolTempData2 = new DataToolTempData(2, "\u674e\u56db2", "\u63cf\u8ff0-\u674e\u56db2");
        list.add(DataToolTempData2);
        list.add(new DataToolTempData(3, "\u738b\u4e94", "\u63cf\u8ff0-\u738b\u4e94"));
        list.add(new DataToolTempData(4, "\u5b8b\u516b", "\u63cf\u8ff0-\u5b8b\u516b"));
        Map<Integer, DataToolTempData> map1 = DataTool.toMapForSaveOld(list, DataToolTempData::getId);
        DataToolExample.assertEquals(list.size() - 1, map1.size());
        DataToolExample.assertEquals(DataToolTempData1, map1.get(2));
        DataToolExample.printMap(map1);
        System.out.println();
        Map<Integer, DataToolTempData> map2 = DataTool.toMapForSaveNew(list, DataToolTempData::getId);
        DataToolExample.assertEquals(list.size() - 1, map2.size());
        DataToolExample.assertEquals(DataToolTempData2, map2.get(2));
        DataToolExample.printMap(map2);
    }

    public static void toMap1() {
        ArrayList<DataToolTempData> list = new ArrayList<DataToolTempData>();
        list.add(new DataToolTempData(1, "\u5f20\u4e09", "\u63cf\u8ff0-\u5f20\u4e09"));
        list.add(new DataToolTempData(2, "\u674e\u56db", "\u63cf\u8ff0-\u674e\u56db"));
        list.add(new DataToolTempData(3, "\u738b\u4e94", "\u63cf\u8ff0-\u738b\u4e94"));
        list.add(new DataToolTempData(4, "\u5b8b\u516b", "\u63cf\u8ff0-\u5b8b\u516b"));
        Map<Integer, DataToolTempData> integerDataToolTempDataMap = DataTool.toMap(list, DataToolTempData::getId);
        DataToolExample.assertEquals(list.size(), integerDataToolTempDataMap.size());
        DataToolExample.printMap(integerDataToolTempDataMap);
    }

    public static void toList() {
        ArrayList<DataToolTempData> list = new ArrayList<DataToolTempData>();
        list.add(new DataToolTempData(1, "\u5f20\u4e09", "\u63cf\u8ff0-\u5f20\u4e09"));
        list.add(new DataToolTempData(2, "\u674e\u56db", "\u63cf\u8ff0-\u674e\u56db"));
        list.add(new DataToolTempData(3, "\u738b\u4e94", "\u63cf\u8ff0-\u738b\u4e94"));
        list.add(new DataToolTempData(4, "\u5b8b\u516b", "\u63cf\u8ff0-\u5b8b\u516b"));
        List<String> resultList = DataTool.toList(list, DataToolTempData::getName);
        DataToolExample.assertEquals(((DataToolTempData)list.get(0)).getName(), resultList.get(0));
        DataToolExample.assertEquals(((DataToolTempData)list.get(2)).getName(), resultList.get(2));
    }

    public static void testToList() {
        HashMap<Integer, DataToolTempMapData1> map = new HashMap<Integer, DataToolTempMapData1>();
        map.put(1, new DataToolTempMapData1(1, new DataToolTempMapData2(1, "map1")));
        map.put(2, new DataToolTempMapData1(2, new DataToolTempMapData2(2, "map2")));
        map.put(3, new DataToolTempMapData1(3, new DataToolTempMapData2(3, "map3")));
        ArrayList<DataToolTempListData3> list = new ArrayList<DataToolTempListData3>();
        list.add(new DataToolTempListData3(1, "A1"));
        list.add(new DataToolTempListData3(2, "A2"));
        list.add(new DataToolTempListData3(3, "A3"));
        list.add(new DataToolTempListData3(4, "A4"));
        List<DataToolTempListResult> DataToolTempListResults = DataTool.toListWithMap(list, map, DataToolTempListData3::getKey, (DataToolTempListData32, DataToolTempMapData12) -> {
            Integer key = DataToolTempListData32.getKey();
            DataToolTempMapData2 DataToolTempMapData22 = DataToolTempMapData12.getDataToolTempMapData2();
            return new DataToolTempListResult(key, DataToolTempMapData22);
        });
        DataToolTempListResults.forEach(System.out::println);
        System.out.println("=========");
        List<DataToolTempListResult> DataToolTempListResults2 = DataTool.toListWithMap(list, map, DataToolTempListData3::getKey, (DataToolTempListData32, DataToolTempMapData12) -> {
            Integer key = DataToolTempListData32.getKey();
            DataToolTempMapData2 DataToolTempMapData22 = DataToolTempMapData12.getDataToolTempMapData2();
            return new DataToolTempListResult(key, DataToolTempMapData22);
        }, DataToolTempListData32 -> {
            Integer key = DataToolTempListData32.getKey();
            return new DataToolTempListResult(key, null);
        });
        DataToolTempListResults2.forEach(System.out::println);
    }

    public static void groupingBy() {
        ArrayList<DataToolTempData> list = new ArrayList<DataToolTempData>();
        list.add(new DataToolTempData(1, "\u5f20\u4e09", "\u63cf\u8ff0-\u5f20\u4e09"));
        list.add(new DataToolTempData(2, "\u674e\u56db", "\u63cf\u8ff0-\u674e\u56db"));
        list.add(new DataToolTempData(2, "\u674e\u56db2", "\u63cf\u8ff0-\u674e\u56db2"));
        list.add(new DataToolTempData(3, "\u738b\u4e94", "\u63cf\u8ff0-\u738b\u4e94"));
        list.add(new DataToolTempData(4, "\u5b8b\u516b", "\u63cf\u8ff0-\u5b8b\u516b"));
        Map<Integer, List<DataToolTempData>> map = DataTool.groupingBy(list, DataToolTempData::getId);
        DataToolExample.assertEquals(list.size() - 1, map.size());
        DataToolExample.assertEquals(2, map.get(2).size());
        DataToolExample.printMap(map);
    }

    public static void deduplicate() {
        ArrayList<DataToolTempData> list = new ArrayList<DataToolTempData>();
        DataToolTempData data1 = new DataToolTempData(1, "\u5f20\u4e09", "\u63cf\u8ff0-\u5f20\u4e09");
        DataToolTempData data2 = new DataToolTempData(2, "\u674e\u56db", "\u63cf\u8ff0-\u674e\u56db");
        DataToolTempData data3 = new DataToolTempData(3, "\u738b\u4e94", "\u63cf\u8ff0-\u738b\u4e94");
        DataToolTempData data4 = new DataToolTempData(null, "\u8d75\u516d", "\u63cf\u8ff0-\u8d75\u516d");
        DataToolTempData data5 = new DataToolTempData(3, "\u6731\u4e03", "\u63cf\u8ff0-\u6731\u4e03");
        DataToolTempData data6 = new DataToolTempData(4, "\u5b8b\u516b", "\u63cf\u8ff0-\u5b8b\u516b");
        list.add(data1);
        list.add(data2);
        list.add(data3);
        list.add(data4);
        list.add(data5);
        list.add(data6);
        DeduplicateResult<Integer, DataToolTempData> deduplicateResult1 = DataTool.deduplicate(list, data -> Objects.nonNull(data.getId()), DataToolTempData::getId, true);
        List<DataToolTempData> deduplicatedList = deduplicateResult1.getDeduplicatedList();
        List<DataToolTempData> repetitiveList = deduplicateResult1.getRepetitiveList();
        List<DataToolTempData> invalidList = deduplicateResult1.getInvalidList();
        List<Integer> deduplicatedKeyList = deduplicateResult1.getDeduplicatedKeyList();
        System.out.println("deduplicatedList");
        deduplicatedList.stream().forEach(System.out::println);
        System.out.println("repetitiveList");
        repetitiveList.stream().forEach(System.out::println);
        System.out.println("invalidList");
        invalidList.stream().forEach(System.out::println);
        System.out.println("deduplicatedKeyList");
        System.out.println(deduplicatedKeyList);
        DataToolExample.assertEquals(1, invalidList.size());
        DataToolExample.assertEquals(data4, invalidList.get(0));
        DataToolExample.assertEquals(4, deduplicatedList.size());
        DataToolExample.assertEquals(1, repetitiveList.size());
        DataToolExample.assertEquals(data5, repetitiveList.get(0));
        DeduplicateResult<Integer, DataToolTempData> deduplicateResult2 = DataTool.deduplicate(list, data -> Objects.nonNull(data.getId()), DataToolTempData::getId, false);
        List<DataToolTempData> deduplicatedList2 = deduplicateResult2.getDeduplicatedList();
        List<DataToolTempData> repetitiveList2 = deduplicateResult2.getRepetitiveList();
        DataToolExample.assertEquals(4, deduplicatedList2.size());
        DataToolExample.assertEquals(data3, repetitiveList2.get(0));
        DeduplicateResult<Integer, DataToolTempData> deduplicateResult3 = DataTool.deduplicate(list, DataToolTempData::getId);
        List<DataToolTempData> deduplicatedList1 = deduplicateResult3.getDeduplicatedList();
        DataToolExample.assertEquals(5, deduplicatedList1.size());
    }

    public static void getDataFromList() {
        DataToolTempDataDTO demoDataDTO = new DataToolTempDataDTO(3, "\u4e0a\u6d77");
        ArrayList<DataToolTempData> list = new ArrayList<DataToolTempData>();
        list.add(new DataToolTempData(1, "\u5317\u4eac", "\u5317\u4eac"));
        list.add(new DataToolTempData(2, "\u5357\u4eac", "\u5357\u4eac"));
        list.add(new DataToolTempData(3, "\u4e0a\u6d77", "\u4e0a\u6d77"));
        DataToolTempData result = DataTool.getDataFromList(demoDataDTO, DataToolTempDataDTO::getId, list, DataToolTempData::getId);
        System.out.println("result = " + result);
        DataToolExample.assertEquals(list.get(2), result);
    }

    public static void handleMap() {
        HashMap<Integer, DataToolTempHandleMapDTO> map = new HashMap<Integer, DataToolTempHandleMapDTO>();
        map.put(1, new DataToolTempHandleMapDTO(1, new DataToolTempDataDTO(1, "AA")));
        map.put(2, new DataToolTempHandleMapDTO(2, new DataToolTempDataDTO(2, "BB")));
        map.put(2, new DataToolTempHandleMapDTO(3, new DataToolTempDataDTO(3, "CC")));
        System.out.println("new Gson().toJson(map) = " + new Gson().toJson(map));
        DataTool.handleMap(map, (k, v) -> {
            if ("AA".equals(k)) {
                new DataToolTempDataDTO(4, "DD");
            }
        });
        System.out.println("new Gson().toJson(map) = " + new Gson().toJson(map));
    }

    public static void testMapToList() {
        HashMap<String, DataToolTempDataDTO> map = new HashMap<String, DataToolTempDataDTO>();
        map.put("A", new DataToolTempDataDTO(1, "AA"));
        map.put("B", new DataToolTempDataDTO(2, "BB"));
        map.put("C", new DataToolTempDataDTO(3, "CC"));
        List<String> keyList = DataTool.mapToList(map, (key, value) -> key);
        List<String> valueList = DataTool.mapToList(map, (key, value) -> value.toString());
        System.out.println("keyList = " + keyList);
        System.out.println("valueList = " + valueList);
        List<String> filteredList = DataTool.mapToList(map, (key, value) -> key.equals("A"), (key, value) -> value.toString());
        System.out.println("filteredList = " + filteredList);
        List<String> valueList2 = DataTool.mapValueToList(map, DataToolTempDataDTO::getNameForVO);
        System.out.println("valueList2 = " + valueList2);
    }

    public static void testGetListFromBaseList() {
        ArrayList<UserInfoDTO> userInfoDTOList = new ArrayList<UserInfoDTO>();
        userInfoDTOList.add(new UserInfoDTO(1, "\u5f20\u4e09"));
        userInfoDTOList.add(new UserInfoDTO(2, "\u674e\u56db"));
        userInfoDTOList.add(new UserInfoDTO(3, "\u738b\u4e94"));
        userInfoDTOList.add(new UserInfoDTO(4, "\u8d75\u516d"));
        userInfoDTOList.add(new UserInfoDTO(5, "\u5b8b\u4e03"));
        ArrayList<UserExtraInfoDTO> userExtraInfoDTOList = new ArrayList<UserExtraInfoDTO>();
        userExtraInfoDTOList.add(new UserExtraInfoDTO(2, 30, "\u5317\u4eac"));
        userExtraInfoDTOList.add(new UserExtraInfoDTO(4, 40, "\u4e0a\u6d77"));
        userExtraInfoDTOList.add(new UserExtraInfoDTO(5, 50, "\u676d\u5dde"));
        List<UserDetailDTO> result = DataTool.getListFromBaseList(userInfoDTOList, UserInfoDTO::getId, userExtraInfoDTOList, UserExtraInfoDTO::getUserId, UserDetailDTO::new);
        result.stream().forEach(System.out::println);
    }

    public static void testGetListFromBaseList2() {
        ArrayList<UserInfoDTO> userInfoDTOList = new ArrayList<UserInfoDTO>();
        userInfoDTOList.add(new UserInfoDTO(1, "\u5f20\u4e09"));
        userInfoDTOList.add(new UserInfoDTO(2, "\u674e\u56db"));
        userInfoDTOList.add(new UserInfoDTO(3, "\u738b\u4e94"));
        userInfoDTOList.add(new UserInfoDTO(4, "\u8d75\u516d"));
        userInfoDTOList.add(new UserInfoDTO(5, "\u5b8b\u4e03"));
        ArrayList<UserExtraInfoDTO2> userExtraInfoDTO2List = new ArrayList<UserExtraInfoDTO2>();
        userExtraInfoDTO2List.add(new UserExtraInfoDTO2(1, "Java \u5f00\u53d1\u624b\u518c", 40));
        userExtraInfoDTO2List.add(new UserExtraInfoDTO2(1, "Python \u5f00\u53d1\u624b\u518c", 8));
        userExtraInfoDTO2List.add(new UserExtraInfoDTO2(2, "Java \u5f00\u53d1\u624b\u518c", 26));
        userExtraInfoDTO2List.add(new UserExtraInfoDTO2(2, "Python \u5f00\u53d1\u624b\u518c", 24));
        userExtraInfoDTO2List.add(new UserExtraInfoDTO2(3, "\u7b97\u6cd5", 400));
        userExtraInfoDTO2List.add(new UserExtraInfoDTO2(5, "\u8bbe\u8ba1\u6a21\u5f0f", 2));
        List<UserDetailDTO2> result = DataTool.getListFromBaseList(userInfoDTOList, UserDetailDTO2::new, UserDetailDTO2::getUserId, userExtraInfoDTO2List, UserExtraInfoDTO2::getUserId, UserDetailDTO2::addReadBookInfo);
        System.out.println("result  = " + new Gson().toJson(result));
    }

    private static void printMap(Map map) {
        Map map1 = map;
        map1.entrySet().forEach(entry -> {
            Object key = entry.getKey();
            Object value = entry.getValue();
            System.out.println(String.format("key = %s, value = %s", key, value));
        });
    }

    private static void assertEquals(Object expected, Object actual) {
        boolean b = DataToolExample.objectsAreEqual(expected, actual);
        if (!b) {
            throw new RuntimeException("\nexpected = " + expected + ", actual = " + actual);
        }
    }

    private static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static void assertNull(Object object) {
        if (object == null) {
            return;
        }
        throw new RuntimeException(object + "\u6821\u9a8c\u4e3a\u7a7a\u5931\u8d25");
    }

    public static void testEnumGroupingBy() {
        Map<String, List<MyEnum>> mapList = DataTool.enumGroupingBy(MyEnum.class, MyEnum::getType);
        System.out.println("mapList = " + mapList);
        DataToolExample.assertEquals(3, mapList.size());
        DataToolExample.assertEquals(2, mapList.get("A").size());
        DataToolExample.assertEquals(2, mapList.get("B").size());
        DataToolExample.assertEquals(1, mapList.get("C").size());
    }
}

