/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business.collection;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.business.collection.CollectionContainer;
import cn.woodwhales.common.business.collection.CollectionFieldComparable;
import cn.woodwhales.common.business.collection.CollectionMath;
import cn.woodwhales.common.business.collection.CollectionTool;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class CollectionMathResult<K, M, N>
implements CollectionMath<K, M, N> {
    private List<M> sourceList1;
    private List<N> sourceList2;
    private Set<CollectionFieldComparable<K>> intersectionSet;
    private Set<CollectionFieldComparable<K>> unionSet;
    private Set<CollectionFieldComparable<K>> positiveDifferenceSet;
    private Set<CollectionFieldComparable<K>> negativeDifferenceSet;
    private boolean lazyCompute;
    private Function<M, K> keyFunction1;
    private Function<N, K> keyFunction2;

    public static <K, M, N> CollectionMathResult<K, M, N> compute(List<M> sourceList1, Function<M, K> keyFunction1, List<N> sourceList2, Function<N, K> keyFunction2) {
        return CollectionMathResult.compute(sourceList1, keyFunction1, sourceList2, keyFunction2, false);
    }

    public static <K, M, N> CollectionMathResult<K, M, N> compute(List<M> sourceList1, Function<M, K> keyFunction1, List<N> sourceList2, Function<N, K> keyFunction2, boolean lazyCompute) {
        CollectionMathResult<K, M, N> collectionMathResult = new CollectionMathResult<K, M, N>(sourceList1, keyFunction1, sourceList2, keyFunction2, lazyCompute);
        if (lazyCompute) {
            return collectionMathResult;
        }
        if (CollectionUtils.isNotEmpty(sourceList1) && CollectionUtils.isEmpty(sourceList2)) {
            Preconditions.checkNotNull(keyFunction1, (Object)"keyFunction1 \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Set<CollectionFieldComparable<K>> set = DataTool.toSet(sourceList1, source1 -> CollectionContainer.build(source1, keyFunction1));
            collectionMathResult.setUnionSet(set).setPositiveDifferenceSet(set).setIntersectionSet(new HashSet<CollectionFieldComparable<K>>()).setNegativeDifferenceSet(new HashSet<CollectionFieldComparable<K>>());
            return collectionMathResult;
        }
        if (CollectionUtils.isEmpty(sourceList1) && CollectionUtils.isNotEmpty(sourceList2)) {
            Preconditions.checkNotNull(keyFunction1, (Object)"keyFunction2 \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Set<CollectionFieldComparable<K>> set = DataTool.toSet(sourceList2, source2 -> CollectionContainer.build(source2, keyFunction2));
            collectionMathResult.setUnionSet(set).setPositiveDifferenceSet(new HashSet<CollectionFieldComparable<K>>()).setIntersectionSet(new HashSet<CollectionFieldComparable<K>>()).setNegativeDifferenceSet(set);
            return collectionMathResult;
        }
        Preconditions.checkNotNull(keyFunction1, (Object)"keyFunction1 \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Preconditions.checkNotNull(keyFunction1, (Object)"keyFunction2 \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Set<CollectionFieldComparable> set1 = DataTool.toSet(sourceList1, source1 -> CollectionContainer.build(source1, keyFunction1));
        Set<CollectionFieldComparable> set2 = DataTool.toSet(sourceList2, source2 -> CollectionContainer.build(source2, keyFunction2));
        collectionMathResult.setPositiveDifferenceSet((Set<CollectionFieldComparable<K>>)Sets.difference(set1, set2)).setNegativeDifferenceSet((Set<CollectionFieldComparable<K>>)Sets.difference(set2, set1)).setUnionSet((Set<CollectionFieldComparable<K>>)Sets.union(set1, set2)).setIntersectionSet((Set<CollectionFieldComparable<K>>)Sets.intersection(set1, set2));
        return collectionMathResult;
    }

    public List<M> getSourceList1() {
        return this.sourceList1;
    }

    public List<N> getSourceList2() {
        return this.sourceList2;
    }

    @Override
    public Set<CollectionFieldComparable<K>> getIntersectionSet() {
        return this.getSet(this.intersectionSet, (set1, set2) -> Sets.intersection((Set)set1, (Set)set2));
    }

    @Override
    public Set<K> getIntersectionKeySet() {
        return this.getKeySet(this.intersectionSet, this.getIntersectionSet());
    }

    public CollectionMathResult<K, M, N> setIntersectionSet(Set<CollectionFieldComparable<K>> intersectionSet) {
        this.intersectionSet = intersectionSet;
        return this;
    }

    @Override
    public Set<K> getUnionKeySet() {
        return this.getKeySet(this.unionSet, this.getUnionSet());
    }

    @Override
    public Set<CollectionFieldComparable<K>> getUnionSet() {
        return this.getSet(this.unionSet, Sets::union);
    }

    public CollectionMathResult<K, M, N> setUnionSet(Set<CollectionFieldComparable<K>> unionSet) {
        this.unionSet = unionSet;
        return this;
    }

    @Override
    public Set<K> getPositiveDifferenceKeySet() {
        return this.getKeySet(this.positiveDifferenceSet, this.getPositiveDifferenceSet());
    }

    @Override
    public List<M> getPositiveDifferenceList() {
        return this.getList(this.sourceList1, this.getPositiveDifferenceSet(), this.keyFunction1);
    }

    @Override
    public Set<CollectionFieldComparable<K>> getPositiveDifferenceSet() {
        return this.getSet(this.positiveDifferenceSet, (set1, set2) -> CollectionTool.difference(set1, set2));
    }

    @Override
    public Set<K> getNegativeDifferenceKeySet() {
        return this.getKeySet(this.negativeDifferenceSet, this.getNegativeDifferenceSet());
    }

    @Override
    public List<N> getNegativeDifferenceList() {
        return this.getList(this.sourceList2, this.getNegativeDifferenceSet(), this.keyFunction2);
    }

    @Override
    public Set<CollectionFieldComparable<K>> getNegativeDifferenceSet() {
        return this.getSet(this.negativeDifferenceSet, (set1, set2) -> CollectionTool.difference(set2, set1));
    }

    private static <K, M, N> CollectionMathResult<K, M, N> empty() {
        return new CollectionMathResult<K, M, N>().setIntersectionSet(new HashSet<CollectionFieldComparable<K>>()).setUnionSet(new HashSet<CollectionFieldComparable<K>>()).setPositiveDifferenceSet(new HashSet<CollectionFieldComparable<K>>()).setNegativeDifferenceSet(new HashSet<CollectionFieldComparable<K>>());
    }

    private CollectionMathResult(List<M> sourceList1, Function<M, K> keyFunction1, List<N> sourceList2, Function<N, K> keyFunction2, boolean lazyCompute) {
        this.sourceList1 = sourceList1;
        this.keyFunction1 = keyFunction1;
        this.sourceList2 = sourceList2;
        this.keyFunction2 = keyFunction2;
        this.lazyCompute = lazyCompute;
    }

    private CollectionMathResult() {
    }

    private Set<K> getKeySet(Set<CollectionFieldComparable<K>> set, Set<CollectionFieldComparable<K>> keySet) {
        if (this.lazyCompute) {
            return keySet.stream().map(CollectionFieldComparable::getDataKey).collect(Collectors.toSet());
        }
        return this.getKeySet(set);
    }

    private Set<K> getKeySet(Set<CollectionFieldComparable<K>> set) {
        return CollectionTool.toSet(set, CollectionFieldComparable::getDataKey);
    }

    private Set<CollectionFieldComparable<K>> getSet(Set<CollectionFieldComparable<K>> set, BinaryOperator<Set<CollectionFieldComparable<K>>> setFunction) {
        if (!this.lazyCompute) {
            return set;
        }
        Set<CollectionFieldComparable> set1 = DataTool.toSet(this.sourceList1, source1 -> CollectionContainer.build(source1, this.keyFunction1));
        Set<CollectionFieldComparable> set2 = DataTool.toSet(this.sourceList2, source2 -> CollectionContainer.build(source2, this.keyFunction2));
        return (Set)setFunction.apply(set1, set2);
    }

    private <T, K> List<T> getList(List<T> list, Set<CollectionFieldComparable<K>> set, Function<T, K> keyFunction) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        Set keySet = set.stream().map(CollectionFieldComparable::getDataKey).collect(Collectors.toSet());
        return DataTool.filter(list, source -> keySet.contains(keyFunction.apply(source)));
    }

    public CollectionMathResult<K, M, N> setPositiveDifferenceSet(Set<CollectionFieldComparable<K>> positiveDifferenceSet) {
        this.positiveDifferenceSet = positiveDifferenceSet;
        return this;
    }

    public CollectionMathResult<K, M, N> setNegativeDifferenceSet(Set<CollectionFieldComparable<K>> negativeDifferenceSet) {
        this.negativeDifferenceSet = negativeDifferenceSet;
        return this;
    }
}

