/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.aspect;

import cn.hutool.core.lang.UUID;
import cn.woodwhales.common.aspect.IgnoreAspect;
import cn.woodwhales.common.util.IpTool;
import cn.woodwhales.common.util.JsonTool;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.core.publisher.Mono;

public class AspectTool {
    private static final Logger log = LoggerFactory.getLogger(AspectTool.class);

    public static Object aspect(ProceedingJoinPoint joinPoint) throws Throwable {
        return AspectTool.aspect(joinPoint, null, requestDto -> {});
    }

    public static Object aspect(ProceedingJoinPoint joinPoint, Function<RequestDto, String> getTraceIdFunction, final Consumer<RequestDto> systemErrorProcessConsumer) throws Throwable {
        RequestDto requestDto = new RequestDto(joinPoint){

            @Override
            public void systemErrorProcess() {
                if (Objects.nonNull(systemErrorProcessConsumer)) {
                    systemErrorProcessConsumer.accept(this);
                }
            }
        };
        requestDto.getTraceIdFunction = getTraceIdFunction;
        return requestDto.execute();
    }

    private static Object collectRequestBodyParam(Object[] args, Signature signature) {
        Method method = ((MethodSignature)signature).getMethod();
        Parameter[] parameters = method.getParameters();
        return Arrays.stream(parameters).filter(parameter -> null != parameter.getAnnotation(RequestBody.class)).map(parameter -> ArrayUtils.indexOf((Object[])parameters, (Object)parameter)).map(index -> args[index]).findFirst().orElse(null);
    }

    private static String getParamStringFromRequest(HttpServletRequest request) {
        return AspectTool.parseEnumerationToString(request.getParameterNames(), arg_0 -> ((HttpServletRequest)request).getParameter(arg_0));
    }

    private static String getHeaderStringFromRequest(HttpServletRequest request) {
        return AspectTool.parseEnumerationToString(request.getHeaderNames(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0));
    }

    private static String parseEnumerationToString(Enumeration<String> enumerations, Function<String, String> function) {
        List list = ListUtils.emptyIfNull((List)EnumerationUtils.toList(enumerations));
        Map map = list.stream().collect(Collectors.toMap(Function.identity(), function));
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(map);
    }

    public static class RequestDto {
        public static final String TRACE_ID_HEADER = "Trace-Id";
        public ProceedingJoinPoint joinPoint;
        public StopWatch stopWatch;
        public String fullMethodName;
        public long costTime;
        public HttpServletRequest request;
        public HttpServletResponse response;
        public String traceId;
        public String clientIpAddress;
        public boolean fromRequest;
        public String requestMethodType;
        public String requestUrl;
        public String requestBody;
        public String requestParam;
        public String responseBody;
        public boolean ignoreAspect;
        public Function<RequestDto, String> getTraceIdFunction;

        public RequestDto(ProceedingJoinPoint joinPoint) {
            this.joinPoint = joinPoint;
            Signature signature = joinPoint.getSignature();
            Class declaringType = signature.getDeclaringType();
            if (declaringType.isAnnotationPresent(IgnoreAspect.class)) {
                this.ignoreAspect = true;
                return;
            }
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            if (method.isAnnotationPresent(IgnoreAspect.class)) {
                this.ignoreAspect = true;
            }
            this.stopWatch = new StopWatch();
            this.start();
            this.fullMethodName = declaringType.getName() + "#" + signature.getName();
            this.fromRequest = Objects.nonNull(RequestContextHolder.getRequestAttributes());
            this.printTraceId();
            this.printRequestParam();
        }

        public void systemErrorProcess() {
        }

        private void printTraceId() {
            if (Objects.nonNull(this.getTraceIdFunction)) {
                this.getTraceIdFunction.apply(this);
            } else {
                if (this.fromRequest) {
                    this.request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                    this.response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                    this.traceId = this.request.getHeader(TRACE_ID_HEADER);
                    if (StringUtils.isBlank((CharSequence)this.traceId)) {
                        this.traceId = UUID.randomUUID().toString(true);
                    }
                    this.request.setAttribute(TRACE_ID_HEADER, (Object)this.traceId);
                } else {
                    this.traceId = UUID.randomUUID().toString(true);
                }
                Thread.currentThread().setName(this.traceId);
            }
        }

        private void printRequestParam() {
            StringBuilder requestParamBuilder = new StringBuilder();
            if (this.fromRequest) {
                this.clientIpAddress = IpTool.getIpAddress(this.request);
                this.requestMethodType = this.request.getMethod();
                this.requestUrl = String.format("[ %s ] %s", this.requestMethodType, this.request.getRequestURL().toString());
                Object requestBodyParam = AspectTool.collectRequestBodyParam(this.joinPoint.getArgs(), this.joinPoint.getSignature());
                if (null != requestBodyParam) {
                    requestParamBuilder.append(JsonTool.toJSONString(requestBodyParam));
                    this.requestBody = requestParamBuilder.toString();
                }
                this.requestParam = AspectTool.getParamStringFromRequest(this.request);
            } else {
                Object[] args = this.joinPoint.getArgs();
                this.requestBody = JsonTool.toJSONString(args);
            }
        }

        public void start() {
            this.stopWatch.start();
        }

        public void stop() {
            this.stopWatch.stop();
            this.costTime = this.stopWatch.getTotalTimeMillis();
        }

        public void fillResponseHeader() {
            if (Objects.nonNull(this.response)) {
                this.response.addHeader(TRACE_ID_HEADER, this.traceId);
            }
        }

        public Object execute() throws Throwable {
            Object object;
            boolean systemError;
            block19: {
                block18: {
                    if (this.ignoreAspect) {
                        return this.joinPoint.proceed();
                    }
                    Object result = null;
                    systemError = false;
                    Throwable throwable = null;
                    try {
                        log.info(">>>>>>>>>> start {}, traceId={}", (Object)this.fullMethodName, (Object)this.traceId);
                        if (this.fromRequest) {
                            log.info("X-AUTH-TOKEN={}", (Object)this.request.getHeader("X-AUTH-TOKEN"));
                        }
                        object = result = this.joinPoint.proceed();
                        this.printResponseBody(result);
                        this.fillResponseHeader();
                        this.stop();
                        if (!systemError) break block18;
                    }
                    catch (Throwable e) {
                        try {
                            systemError = true;
                            throwable = e;
                            throw e;
                        }
                        catch (Throwable throwable2) {
                            this.printResponseBody(result);
                            this.fillResponseHeader();
                            this.stop();
                            if (systemError) {
                                String errorMsg = throwable instanceof NullPointerException ? "NPE" : throwable.getMessage();
                                if (this.fromRequest) {
                                    log.error("\u5f02\u5e38\u5f02\u5e38! errorMsg={}, requestUrl={}, requestBody={}, consume={}ms", new Object[]{errorMsg, this.requestUrl, this.requestBody, this.costTime, throwable});
                                } else {
                                    log.error("\u5f02\u5e38\u5f02\u5e38! errorMsg={}, requestBody={}, consume={}ms", new Object[]{errorMsg, this.requestBody, this.costTime, throwable});
                                }
                            } else if (this.fromRequest) {
                                log.info("clientIP={}, requestUrl={}, requestBody={}, responseBody={}, consume={}ms", new Object[]{this.clientIpAddress, this.requestUrl, this.requestBody, this.responseBody, this.costTime});
                            } else {
                                log.info("requestBody={}, responseBody={}, consume={}ms", new Object[]{this.requestBody, this.responseBody, this.costTime});
                            }
                            if (systemError) {
                                this.systemErrorProcess();
                            }
                            log.info("<<<<<<<<<< end {}, traceId={}, consume={}ms", new Object[]{this.fullMethodName, this.traceId, this.costTime});
                            throw throwable2;
                        }
                    }
                    String errorMsg = throwable instanceof NullPointerException ? "NPE" : throwable.getMessage();
                    if (this.fromRequest) {
                        log.error("\u5f02\u5e38\u5f02\u5e38! errorMsg={}, requestUrl={}, requestBody={}, consume={}ms", new Object[]{errorMsg, this.requestUrl, this.requestBody, this.costTime, throwable});
                    } else {
                        log.error("\u5f02\u5e38\u5f02\u5e38! errorMsg={}, requestBody={}, consume={}ms", new Object[]{errorMsg, this.requestBody, this.costTime, throwable});
                    }
                    break block19;
                }
                if (this.fromRequest) {
                    log.info("clientIP={}, requestUrl={}, requestBody={}, responseBody={}, consume={}ms", new Object[]{this.clientIpAddress, this.requestUrl, this.requestBody, this.responseBody, this.costTime});
                } else {
                    log.info("requestBody={}, responseBody={}, consume={}ms", new Object[]{this.requestBody, this.responseBody, this.costTime});
                }
            }
            if (systemError) {
                this.systemErrorProcess();
            }
            log.info("<<<<<<<<<< end {}, traceId={}, consume={}ms", new Object[]{this.fullMethodName, this.traceId, this.costTime});
            return object;
        }

        private void printResponseBody(Object result) {
            if (Objects.isNull(result)) {
                return;
            }
            if (result instanceof Mono) {
                ((Mono)result).subscribe(resp -> {
                    if (resp instanceof ResponseEntity) {
                        ResponseEntity responseEntity = (ResponseEntity)resp;
                        HttpHeaders headers = responseEntity.getHeaders();
                        MediaType contentType = headers.getContentType();
                        if (Objects.nonNull(contentType) && MediaType.APPLICATION_OCTET_STREAM.getType().equals(contentType.getType())) {
                            this.responseBody = "\u6587\u4ef6\u6d41\u4e0d\u6253\u5370\u54cd\u5e94\u65e5\u5fd7";
                        } else {
                            Object body = ((ResponseEntity)resp).getBody();
                            this.responseBody = JsonTool.toJSONString(body);
                        }
                    }
                });
            } else {
                this.responseBody = JsonTool.toJSONString(result);
            }
        }
    }
}

