/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.event;

import cn.woodwhales.common.webhook.event.WebhookEvent;
import cn.woodwhales.common.webhook.executor.WebhookExecutorFactory;
import cn.woodwhales.common.webhook.plugin.WebhookExtraInfo;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookEventHandler {
    private static final Logger log = LoggerFactory.getLogger(WebhookEventHandler.class);

    public static void handleCustomEvent(WebhookEvent webhookEvent, String noticeUrl, String secret, String basePackageName, WebhookExtraInfo webhookExtraInfo) {
        String finalNoticeUrl = (String)StringUtils.defaultIfBlank((CharSequence)webhookEvent.getNoticeUrl(), (CharSequence)noticeUrl);
        if (StringUtils.isBlank((CharSequence)webhookEvent.getNoticeUrl())) {
            webhookEvent.setNoticeUrl(finalNoticeUrl);
        }
        String finalSecret = (String)StringUtils.defaultIfBlank((CharSequence)webhookEvent.getSecret(), (CharSequence)secret);
        String[] finalBasePackageNames = Objects.nonNull(webhookEvent.getBasePackageNames()) ? webhookEvent.getBasePackageNames() : StringUtils.split((String)basePackageName, (String)",");
        log.info("\u76d1\u542c\u5230\u5f02\u5e38\u62a5\u8b66\u4e8b\u4ef6\uff0c\u6d88\u606f\u6807\u9898\uff1a{}, \u53d1\u5e03\u65f6\u95f4\uff1a{}", (Object)webhookEvent.getTitle(), (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        WebhookExecutorFactory.Builder.build(finalNoticeUrl, webhookEvent.getTitle(), webhookEvent.getBaseWebhookRequestBody()).throwable(webhookEvent.getThrowable(), finalBasePackageNames).userIdList(webhookEvent.getUserIdList()).userMobileList(webhookEvent.getUserMobileList()).secret(finalSecret).webhookExtraInfo(webhookExtraInfo).execute();
    }
}

