/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util.excel;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.util.excel.DrawSlashContext;
import cn.woodwhales.common.util.excel.ExcelDateField;
import cn.woodwhales.common.util.excel.ExcelField;
import cn.woodwhales.common.util.excel.ExcelFieldType;
import cn.woodwhales.common.util.excel.NullValueHandler;
import cn.woodwhales.common.util.excel.ParseDataModel;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelTool {
    public static <T> List<T> parseData(String filePath, BiFunction<ParseDataModel, Row, T> function) {
        return ExcelTool.parseData(filePath, 0, 1, function);
    }

    public static <T> List<T> parseData(InputStream inputStream, BiFunction<ParseDataModel, Row, T> function) {
        return ExcelTool.parseData(ExcelTool.buildWorkbook(inputStream), 0, 1, function, null);
    }

    public static <T> List<T> parseData(InputStream inputStream, int sheetIndex, int skipLineNumbers, BiFunction<ParseDataModel, Row, T> function) {
        return ExcelTool.parseData(ExcelTool.buildWorkbook(inputStream), sheetIndex, skipLineNumbers, function, null);
    }

    public static <T> List<T> parseData(String fileName, Class<T> clazz) {
        return ExcelTool.parseData(new File(fileName), clazz);
    }

    public static <T> List<T> parseData(File file, Class<T> clazz) {
        try {
            return ExcelTool.parseData((InputStream)new FileInputStream(file), clazz);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseData(InputStream inputStream, Class<T> clazz) {
        Field[] declaredFields = FieldUtils.getAllFields(clazz);
        Map<String, ExcelFieldConfig> excelFieldConfigMap = DataTool.toMapForSaveNew(DataTool.toList(declaredFields, ExcelFieldConfig::new), ExcelFieldConfig::getExcelFieldName);
        AtomicReference excelFieldConfigMap2 = new AtomicReference();
        return ExcelTool.parseData(ExcelTool.buildWorkbook(inputStream), 0, 1, (parseDataModel, row) -> {
            int maxCellNumber = parseDataModel.maxCellNumber;
            Object target = null;
            Cell cell = null;
            try {
                target = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (int cellIndex = 0; cellIndex < maxCellNumber; ++cellIndex) {
                    cell = row.getCell(cellIndex);
                    ExcelFieldConfig excelFieldConfig = (ExcelFieldConfig)((Map)excelFieldConfigMap2.get()).get(cellIndex);
                    ExcelTool.fillFieldValue(target, row, cell, excelFieldConfig);
                }
            }
            catch (Exception e) {
                System.err.printf("index = %s, cell value = [%s], parese error, cause by : %s\n", parseDataModel.rowIndex, cell, e.getMessage());
                e.printStackTrace();
            }
            return target;
        }, (cellIndex, row) -> {
            Cell cell = row.getCell(cellIndex.intValue());
            if (Objects.nonNull(cell)) {
                String cellName = cell.getStringCellValue();
                if (excelFieldConfigMap.containsKey(cellName)) {
                    ((ExcelFieldConfig)excelFieldConfigMap.get((Object)cellName)).cellIndex = cellIndex;
                }
                if (cellIndex.equals(row.getPhysicalNumberOfCells() - 1)) {
                    excelFieldConfigMap2.set(DataTool.toMapForSaveNew(excelFieldConfigMap.values(), ExcelFieldConfig::getCellIndex));
                }
            }
        });
    }

    private static <T> void fillFieldValue(T target, Row row, Cell cell, ExcelFieldConfig excelFieldConfig) throws IllegalAccessException {
        if (Objects.isNull(excelFieldConfig)) {
            return;
        }
        excelFieldConfig.fillField(target, row, cell, excelFieldConfig);
    }

    public static void exportToOutputStream(Workbook workbook, File file) {
        try {
            ExcelTool.exportToOutputStream(workbook, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void exportToOutputStream(Workbook workbook, OutputStream outputStream) {
        try {
            workbook.write(outputStream);
            outputStream.close();
            workbook.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> List<T> parseData(String filePath, int sheetIndex, int skipLineNumbers, BiFunction<ParseDataModel, Row, T> function) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException(filePath + " \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Workbook workbook = ExcelTool.buildWorkbook(file);
        return ExcelTool.parseData(workbook, sheetIndex, skipLineNumbers, function, null);
    }

    private static <T> List<T> parseData(Workbook workbook, int sheetIndex, int skipLineNumbers, BiFunction<ParseDataModel, Row, T> function, BiConsumer<Integer, Row> skipConsumer) {
        Sheet sheet;
        Objects.requireNonNull(function, "function\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (Objects.isNull(sheetIndex)) {
            sheetIndex = 0;
        }
        if (Objects.isNull(skipLineNumbers)) {
            skipLineNumbers = 0;
        }
        if (Objects.isNull(sheet = workbook.getSheetAt(sheetIndex))) {
            throw new RuntimeException("sheetIndex = " + sheetIndex + " \u4e0d\u5b58\u5728");
        }
        ArrayList<T> dataList = new ArrayList<T>(sheet.getLastRowNum());
        int rowIndex = 0;
        Integer maxCellNumber = 0;
        while (rowIndex <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(rowIndex);
            if (Objects.isNull(row)) {
                ++rowIndex;
                continue;
            }
            if (row.getRowNum() < skipLineNumbers) {
                if (Objects.nonNull(skipConsumer)) {
                    int lastCellNum = row.getLastCellNum();
                    if (lastCellNum > maxCellNumber) {
                        maxCellNumber = lastCellNum;
                    }
                    for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
                        skipConsumer.accept(cellIndex, row);
                    }
                }
                ++rowIndex;
                continue;
            }
            Integer tmpRowIndex = rowIndex;
            T data = function.apply(new ParseDataModel(tmpRowIndex, maxCellNumber), row);
            dataList.add(data);
            ++rowIndex;
        }
        return dataList;
    }

    public static Cell getCell(Row row, int index) {
        Cell cell = row.getCell(index);
        if (Objects.isNull(cell)) {
            cell = row.createCell(index);
        }
        return cell;
    }

    public static String getStringValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return "";
        }
        if (!Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            cell.setCellType(CellType.STRING);
        }
        return cell.getStringCellValue();
    }

    public static Byte getByteValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return numericCellValue.byteValue();
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Byte.parseByte(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static Long getLongValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return Long.parseLong(ExcelTool.formatNumeric(numericCellValue));
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Long.parseLong(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static Double getDoubleValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return Double.parseDouble(ExcelTool.formatNumeric(numericCellValue));
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Double.parseDouble(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static String formatNumeric(Double numericCellValue) {
        DecimalFormat decimalFormat = new DecimalFormat("0");
        if (Objects.isNull(numericCellValue)) {
            return null;
        }
        return decimalFormat.format(numericCellValue);
    }

    public static Integer getIntegerValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return Integer.parseInt(ExcelTool.formatNumeric(numericCellValue));
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Integer.parseInt(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static Date getDateValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            Date date = cell.getDateCellValue();
            return date;
        }
        return null;
    }

    public static String getFormatDateValue(Row row, int cellIndex) {
        return ExcelTool.getFormatDateValue(row, cellIndex, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatDateValue(Row row, int cellIndex, String pattern) {
        Date dateValue = ExcelTool.getDateValue(row, cellIndex);
        if (Objects.isNull(dateValue)) {
            return "";
        }
        return DateFormatUtils.format((Date)dateValue, (String)pattern);
    }

    public static Workbook buildWorkbook(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public static Workbook buildWorkbook(File file) {
        Workbook workbook = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            workbook = ExcelTool.buildWorkbook(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private ExcelTool() {
    }

    public static void drawSlash(DrawSlashContext drawSlashContext) {
        XSSFSimpleShape shape;
        ClientAnchor anchor;
        XSSFDrawing drawing;
        Workbook workbook = drawSlashContext.workbook;
        Sheet sheet = drawSlashContext.sheet;
        CreationHelper helper = workbook.getCreationHelper();
        if (workbook instanceof XSSFWorkbook) {
            drawing = (XSSFDrawing)sheet.createDrawingPatriarch();
            anchor = helper.createClientAnchor();
            anchor.setCol1(drawSlashContext.col1);
            anchor.setRow1(drawSlashContext.row1);
            anchor.setCol2(drawSlashContext.col2);
            anchor.setRow2(drawSlashContext.row2);
            shape = drawing.createSimpleShape((XSSFClientAnchor)anchor);
            shape.setShapeType(1);
            shape.setLineWidth(0.5);
            shape.setLineStyle(0);
            shape.setLineStyleColor(0, 0, 0);
        }
        if (workbook instanceof HSSFWorkbook) {
            drawing = (HSSFPatriarch)sheet.createDrawingPatriarch();
            anchor = helper.createClientAnchor();
            anchor.setCol1(drawSlashContext.col1);
            anchor.setRow1(drawSlashContext.row1);
            anchor.setCol2(drawSlashContext.col2);
            anchor.setRow2(drawSlashContext.row2);
            shape = drawing.createSimpleShape((HSSFClientAnchor)anchor);
            shape.setShapeType(20);
            shape.setLineWidth(6350);
            shape.setLineStyle(0);
            shape.setLineStyleColor(0, 0, 0);
        }
    }

    private static class ExcelFieldConfig {
        public ExcelFieldType excelFieldType;
        public Field field;
        public boolean jsonFlag;
        public Integer cellIndex;
        public Class<?> clazz;
        public String excelFieldName;
        public String pattern;
        public NullValueHandler nullValueHandler;

        private ExcelFieldConfig() {
        }

        ExcelFieldConfig(Field field) {
            ExcelDateField excelDateField;
            this.field = field;
            ExcelField excelField = field.getAnnotation(ExcelField.class);
            if (Objects.nonNull(excelField)) {
                this.excelFieldType = ExcelFieldType.NORMAL;
                this.jsonFlag = excelField.jsonFlag();
                this.clazz = excelField.type();
                this.excelFieldName = (String)StringUtils.defaultIfBlank((CharSequence)excelField.value(), (CharSequence)field.getName());
                Class<?> nullValueHandlerClass = excelField.nullValueHandler();
                if (Objects.nonNull(nullValueHandlerClass) && NullValueHandler.class.isAssignableFrom(nullValueHandlerClass)) {
                    try {
                        this.nullValueHandler = (NullValueHandler)nullValueHandlerClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (Objects.nonNull(excelDateField = field.getAnnotation(ExcelDateField.class))) {
                this.excelFieldType = ExcelFieldType.DATE_STR;
                this.clazz = String.class;
                this.excelFieldName = excelDateField.value();
                this.pattern = excelDateField.pattern();
                Class<NullValueHandler> nullValueHandlerClass = excelDateField.nullValueHandler();
                if (Objects.nonNull(nullValueHandlerClass) && nullValueHandlerClass.isAssignableFrom(NullValueHandler.class)) {
                    try {
                        this.nullValueHandler = (NullValueHandler)nullValueHandlerClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (Objects.isNull(excelField) && Objects.isNull(excelDateField)) {
                this.excelFieldType = ExcelFieldType.DEFAULT;
                this.clazz = field.getType();
                this.excelFieldName = field.getName();
            }
        }

        public String getExcelFieldName() {
            return this.excelFieldName;
        }

        public Integer getCellIndex() {
            return this.cellIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fillField(Object target, Row row, Cell cell, ExcelFieldConfig excelFieldConfig) throws IllegalAccessException {
            boolean accessible = this.field.isAccessible();
            this.field.setAccessible(true);
            String typeName = this.clazz.getName();
            try {
                if (this.jsonFlag) {
                    String jsonStr = ExcelTool.getStringValue(row, this.cellIndex);
                    if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                        this.field.set(target, new Gson().fromJson(jsonStr, this.field.getType()));
                    } else {
                        this.defaultValueWhenExcelDataIsNull(target, excelFieldConfig);
                    }
                    return;
                }
                if (Objects.isNull(cell)) {
                    this.defaultValueWhenExcelDataIsNull(target, excelFieldConfig);
                    return;
                }
                if (String.class.getName().equals(typeName)) {
                    if (ExcelFieldType.DATE_STR.equals((Object)this.excelFieldType)) {
                        this.field.set(target, DateFormatUtils.format((Date)ExcelTool.getDateValue(row, this.cellIndex), (String)this.pattern));
                    } else {
                        this.field.set(target, cell.getStringCellValue());
                    }
                } else if (Integer.class.getName().equals(typeName)) {
                    this.field.set(target, ExcelTool.getIntegerValue(row, this.cellIndex));
                } else if (Double.class.getName().equals(typeName)) {
                    this.field.set(target, ExcelTool.getDoubleValue(row, this.cellIndex));
                } else if (Date.class.getName().equals(typeName)) {
                    this.field.set(target, ExcelTool.getDateValue(row, this.cellIndex));
                } else if (Byte.class.getName().equals(typeName)) {
                    this.field.set(target, ExcelTool.getByteValue(row, this.cellIndex));
                }
            }
            finally {
                this.field.setAccessible(accessible);
            }
        }

        private void defaultValueWhenExcelDataIsNull(Object target, ExcelFieldConfig excelFieldConfig) throws IllegalAccessException {
            Object defaultValue;
            if (Objects.nonNull(excelFieldConfig.nullValueHandler) && Objects.nonNull(defaultValue = excelFieldConfig.nullValueHandler.defaultValueIfExcelDataIdNull())) {
                if (!defaultValue.getClass().isAssignableFrom(excelFieldConfig.field.getType())) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5[%s]\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u503c\u7c7b\u4e0d\u5408\u6cd5", excelFieldConfig.excelFieldName));
                }
                excelFieldConfig.field.set(target, defaultValue);
            }
        }
    }
}

