/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TimeTool {
    private static final String date_pattern = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String default_pattern = "yyyy-MM-dd HH:mm:ss";
    private static final String normal_datetime_ms_pattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String local_date_time_pattern = "uuuu-MM-dd'T'HH:mm:ss.SSS";

    public static String convertDateStr(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = null;
        if (StringUtils.length((CharSequence)dateStr) == date_pattern.length()) {
            dateTimeFormatter = DateTimeFormatter.ofPattern(date_pattern, Locale.ENGLISH);
        } else if (StringUtils.length((CharSequence)dateStr) == local_date_time_pattern.length()) {
            dateTimeFormatter = DateTimeFormatter.ofPattern(local_date_time_pattern, Locale.ENGLISH);
        }
        if (Objects.isNull(dateTimeFormatter)) {
            return null;
        }
        LocalDateTime parseLocalDateTime = LocalDateTime.parse(dateStr, dateTimeFormatter);
        return TimeTool.format(parseLocalDateTime, default_pattern);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return formatter.format(localDateTime);
    }

    public static LocalDateTime getBeijingTime() {
        return LocalDateTime.now(ZoneOffset.of("+8"));
    }

    public static LocalDateTime getMexicoTime() {
        return TimeTool.localDateTime("-6");
    }

    public static LocalDateTime getGMTTime() {
        return LocalDateTime.now(ZoneOffset.of("+0"));
    }

    public static LocalDateTime localDateTime(String zoneId) {
        return ZonedDateTime.now(ZoneId.of(zoneId)).toLocalDateTime();
    }
}

