/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util;

import cn.hutool.core.lang.UUID;
import cn.woodwhales.common.util.IpTool;
import cn.woodwhales.common.util.JsonTool;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestAspectTool {
    private static final Logger log = LoggerFactory.getLogger(RequestAspectTool.class);

    public static Object aspect(ProceedingJoinPoint joinPoint) throws Throwable {
        return RequestAspectTool.aspect(joinPoint, () -> UUID.randomUUID().toString(true), request -> request.setAttribute("traceId", (Object)Thread.currentThread().getName()), null);
    }

    public static Object aspect(ProceedingJoinPoint joinPoint, Supplier<String> requestIdSupplier, Consumer<HttpServletRequest> beforeConsumer, BiConsumer<HttpServletRequest, Object> afterConsumer) throws Throwable {
        Object object;
        String requestId;
        if (Objects.nonNull(requestIdSupplier) && StringUtils.isNotBlank((CharSequence)(requestId = requestIdSupplier.get()))) {
            Thread.currentThread().setName(requestId);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Signature signature = joinPoint.getSignature();
        String declaringTypeName = signature.getDeclaringType().getName();
        String fullMethodName = declaringTypeName + "#" + signature.getName();
        StringBuilder requestParamBuilder = new StringBuilder();
        String requestUrl = null;
        try {
            Object requestBodyParam;
            log.info("======================= {} start =======================", (Object)fullMethodName);
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String clientIpAddress = IpTool.getIpAddress(request);
            String methodType = request.getMethod();
            requestUrl = String.format("[ %s ] %s", methodType, request.getRequestURL().toString());
            log.info("request_url={}", (Object)requestUrl);
            log.info("request_ip={}", (Object)clientIpAddress);
            log.info("request_param={}", (Object)requestParamBuilder.append(RequestAspectTool.getParamStringFromRequest(request)));
            if (!StringUtils.equals((CharSequence)RequestMethod.GET.name(), (CharSequence)methodType) && null != (requestBodyParam = RequestAspectTool.collectRequestBodyParam(joinPoint.getArgs(), signature))) {
                log.info("request_requestBody={}", (Object)requestParamBuilder.append(JsonTool.toJSONString(requestBodyParam)));
            }
            if (Objects.nonNull(beforeConsumer)) {
                beforeConsumer.accept(request);
            }
            Object result = joinPoint.proceed();
            RequestAspectTool.printResponseBody(result);
            if (Objects.nonNull(afterConsumer)) {
                afterConsumer.accept(request, result);
            }
            object = result;
        }
        catch (Throwable throwable) {
            try {
                String requestParam = requestParamBuilder.toString();
                log.error("system happen error {}, requestParam : {}", new Object[]{requestUrl, requestParam, throwable});
                throw throwable;
            }
            catch (Throwable throwable2) {
                long costTime = stopWatch.getTotalTimeMillis();
                log.info("requestUrl = {}, consume : {} ms", requestUrl, (Object)costTime);
                log.info("======================= {} end =======================", (Object)fullMethodName);
                throw throwable2;
            }
        }
        long costTime = stopWatch.getTotalTimeMillis();
        log.info("requestUrl = {}, consume : {} ms", (Object)requestUrl, (Object)costTime);
        log.info("======================= {} end =======================", (Object)fullMethodName);
        return object;
    }

    private static void printResponseBody(Object result) {
        if (Objects.isNull(result)) {
            log.info("request_responseBody={}", (Object)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return;
        }
        if (result instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)result;
            HttpHeaders headers = responseEntity.getHeaders();
            MediaType contentType = headers.getContentType();
            if (Objects.nonNull(contentType) && MediaType.APPLICATION_OCTET_STREAM.getType().equals(contentType.getType())) {
                log.info("request_responseBody={}", (Object)"\u54cd\u5e94\u62a5\u6587\u4e3a\u6587\u4ef6\u6d41, \u4e0d\u6253\u5370\u54cd\u5e94\u62a5\u6587");
            } else {
                log.info("request_responseBody={}", (Object)JsonTool.toJSONString(result));
            }
            return;
        }
        if (result.getClass().isArray()) {
            log.info("request_responseBody={}", (Object)"\u54cd\u5e94\u62a5\u6587\u4e3a\u6570\u7ec4, \u4e0d\u6253\u5370\u54cd\u5e94\u62a5\u6587");
            return;
        }
        log.info("request_responseBody={}", (Object)JsonTool.toJSONString(result));
    }

    private static Object collectRequestBodyParam(Object[] args, Signature signature) {
        Method method = ((MethodSignature)signature).getMethod();
        Parameter[] parameters = method.getParameters();
        return Arrays.stream(parameters).filter(parameter -> null != parameter.getAnnotation(RequestBody.class)).map(parameter -> ArrayUtils.indexOf((Object[])parameters, (Object)parameter)).map(index -> args[index]).findFirst().orElse(null);
    }

    private static String getParamStringFromRequest(HttpServletRequest request) {
        return RequestAspectTool.parseEnumerationToString(request.getParameterNames(), arg_0 -> ((HttpServletRequest)request).getParameter(arg_0));
    }

    private static String getHeaderStringFromRequest(HttpServletRequest request) {
        return RequestAspectTool.parseEnumerationToString(request.getHeaderNames(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0));
    }

    private static String parseEnumerationToString(Enumeration<String> enumerations, Function<String, String> function) {
        List list = ListUtils.emptyIfNull((List)EnumerationUtils.toList(enumerations));
        Map map = list.stream().collect(Collectors.toMap(Function.identity(), function));
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(map);
    }
}

