/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTool {
    private static final Logger log = LoggerFactory.getLogger(JsonTool.class);

    public static String toJSONString(Object object) {
        return new Gson().toJson(object);
    }

    public static <T> T parse(String jsonStr, TypeReference<T> typeReference, Map<String, String> replaceMap) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            log.warn("this jsonStr is blank");
            return null;
        }
        if (MapUtils.isNotEmpty(replaceMap)) {
            for (Map.Entry<String, String> replaceEntry : replaceMap.entrySet()) {
                if (!StringUtils.contains((CharSequence)jsonStr, (CharSequence)replaceEntry.getKey())) continue;
                jsonStr = StringUtils.replace((String)jsonStr, (String)replaceEntry.getKey(), (String)replaceEntry.getValue());
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        Object target = null;
        try {
            target = mapper.readValue(jsonStr, typeReference);
        }
        catch (JsonProcessingException e) {
            log.error("parse fail, jsonStr = {}, errorMsg = {}", new Object[]{jsonStr, e.getMessage(), e});
        }
        return (T)target;
    }

    public static <T> T parse(String jsonStr, TypeReference<T> typeReference) {
        return JsonTool.parse(jsonStr, typeReference, null);
    }
}

