/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.webhook.springboot;

import cn.woodwhales.common.webhook.event.WebhookEvent;
import cn.woodwhales.common.webhook.event.WebhookEventHandler;
import cn.woodwhales.common.webhook.plugin.WebhookExtraInfo;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class ApplicationEventConfig {
    private static final Logger log = LogManager.getLogger(ApplicationEventConfig.class);
    @Value(value="${notice.url:}")
    private String noticeUrl;
    @Value(value="${notice.secret:}")
    private String secret = "";
    private String basePackageName = "cn.woodwhales.webhook";

    @Bean
    public WebhookExtraInfo webhookExtraInfo() {
        return new WebhookExtraInfo(5L, TimeUnit.MINUTES);
    }

    @EventListener
    public void handleCustomEvent(WebhookEvent webhookEvent) {
        WebhookEventHandler.handleCustomEvent(webhookEvent, this.noticeUrl, this.secret, this.basePackageName, this.webhookExtraInfo());
    }
}

