/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.business.tree;

import cn.woodwhales.common.business.tree.TreeNode;
import cn.woodwhales.common.business.tree.TreeNodeAttributeMapper;
import cn.woodwhales.common.business.tree.TreeTool;
import cn.woodwhales.common.example.model.business.tree.MyTreeNodeGenerator;
import cn.woodwhales.common.example.model.business.tree.TreeToolTempMenu;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TreeToolExample {
    private static List<TreeToolTempMenu> testList;

    public static void main(String[] args) {
        TreeToolExample.test1();
        TreeToolExample.test2();
        TreeToolExample.test3();
        TreeToolExample.test4();
        TreeToolExample.test5();
        TreeToolExample.test6();
    }

    public static void init() {
        ArrayList list = Lists.newArrayListWithCapacity((int)6);
        list.add(new TreeToolTempMenu(9, null, "\u4e0a\u6d77", 30, "\u4e0a\u6d77\u5f88\u7f8e").setExtraInfo1("\u6709\u4e1c\u65b9\u660e\u73e0").setExtraInfo2("\u6709\u4e0a\u6d77\u6ee9"));
        list.add(new TreeToolTempMenu(1, null, "\u5317\u4eac", 10, "\u5317\u4eac\u662f\u9996\u90fd"));
        list.add(new TreeToolTempMenu(2, 1, "\u6d77\u6dc0", 1, "\u6709\u5f88\u591a\u5927\u5b66"));
        list.add(new TreeToolTempMenu(4, 1, "\u897f\u57ce", 3, "\u5317\u4eac\u7684\u897f\u8fb9"));
        list.add(new TreeToolTempMenu(3, 1, "\u671d\u9633", 2, "CBD\u805a\u96c6\u5730").setExtraInfo1("\u6709\u4e09\u91cc\u5c6f").setExtraInfo2("\u6709\u671d\u9633\u5927\u60a6\u57ce"));
        list.add(new TreeToolTempMenu(10, 3, "\u4e09\u91cc\u5c6f", 1, "\u4e09\u91cc\u5c6f"));
        list.add(new TreeToolTempMenu(11, 3, "\u53cc\u4e95\u7ad9", 2, "\u53cc\u4e95\u7ad9"));
        list.add(new TreeToolTempMenu(9, 1, "\u4e1c\u57ce", 0, "\u5317\u4eac\u7684\u4e1c\u8fb9"));
        list.add(new TreeToolTempMenu(5, null, "\u5b89\u5fbd", 20, "\u6709\u5f88\u591a\u5c71").setExtraInfo1("\u6709\u8336\u53f6").setExtraInfo2("\u6709\u5c71\u6709\u6c34"));
        list.add(new TreeToolTempMenu(6, 5, "\u5408\u80a5", 1, "\u5b89\u5fbd\u7701\u4f1a").setExtraInfo1("\u6709\u4e2d\u79d1\u5927").setExtraInfo2("\u6709\u6b65\u884c\u8857"));
        list.add(new TreeToolTempMenu(7, 5, "\u5b89\u5e86", 2, "\u9ec4\u6885\u620f\u5f88\u6709\u540d").setExtraInfo1("\u4e0d\u77e5\u9053\u6709\u5565").setExtraInfo2("\u6709\u706b\u8f66\u7ad9"));
        list.add(new TreeToolTempMenu(8, 5, "\u9ec4\u5c71", 3, "\u6709\u8fce\u5ba2\u677e").setExtraInfo1("\u5c71\u4e0a\u6709\u77f3\u5934").setExtraInfo2("\u5c71\u4e0a\u6709\u6811\u6728"));
        testList = list;
    }

    public static void test1() {
        TreeToolExample.init();
        List<TreeNode<Integer, TreeToolTempMenu>> tree = TreeTool.tree(testList, new MyTreeNodeGenerator());
        TreeToolExample.print(tree);
    }

    public static void test2() {
        TreeToolExample.init();
        List<Map<String, Object>> tree = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeIdName("key").childrenName("child").parentId("fatherId").sortName(null).build());
        TreeToolExample.print(tree);
    }

    public static void test3() {
        TreeToolExample.init();
        List<Map<String, Object>> tree = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeIdName("key").nodeName("key").childrenName("child").parentId("fatherId").sortName("weight").dataName("origin").build(), true);
        TreeToolExample.print(tree);
    }

    public static void test4() {
        TreeToolExample.init();
        List<Map<String, Object>> tree = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeIdName("key").overNodeId(TreeToolTempMenu::getCityName).build(), true);
        TreeToolExample.print(tree);
    }

    public static void test5() {
        TreeToolExample.init();
        List<Map<String, Object>> tree = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeIdName("key").overNodeId(TreeToolTempMenu::getCityName).build(), TreeToolTempMenu::getMemo, false);
        TreeToolExample.print(tree);
    }

    public static void test6() {
        TreeToolExample.init();
        ArrayList extraMappingList = new ArrayList();
        extraMappingList.add(new TreeNodeAttributeMapper.ExtraMapping<TreeToolTempMenu>("\u5907\u6ce81", TreeToolTempMenu::getExtraInfo1));
        extraMappingList.add(new TreeNodeAttributeMapper.ExtraMapping<TreeToolTempMenu>("\u5907\u6ce82", TreeToolTempMenu::getExtraInfo2));
        List<Map<String, Object>> test = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().extraMappingList(extraMappingList).build());
        TreeToolExample.print(test);
    }

    private static void print(Object object) {
        System.out.println("data => " + new Gson().toJson(object));
    }
}

