/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business.tree;

import cn.woodwhales.common.business.tree.TreeNodeAttributeMapper;
import cn.woodwhales.common.business.tree.TreeNodeGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeNode<K, T> {
    private K id;
    private K parentId;
    private String name;
    private T data;
    private List<TreeNode<K, T>> children;
    private int sort;

    private TreeNode() {
    }

    public static <K, T> TreeNode<K, T> build(T data, TreeNodeGenerator<K, T> treeNodeGenerator) {
        TreeNode<K, T> treeNode = new TreeNode<K, T>();
        treeNode.setId(treeNodeGenerator.getId(data));
        treeNode.setData(data);
        treeNode.setName(treeNodeGenerator.getName(data));
        treeNode.setParentId(treeNodeGenerator.getParentId(data));
        treeNode.setSort(treeNodeGenerator.getSort(data));
        return treeNode;
    }

    public static <K, T> TreeNode<K, T> build(T data, TreeNodeGenerator<K, T> treeNodeGenerator, TreeNodeAttributeMapper<T> treeNodeAttributeMapper) {
        TreeNode<K, T> treeNode = new TreeNode<K, T>();
        treeNode.setId(treeNodeGenerator.getId(data));
        treeNode.setData(data);
        treeNode.setName(treeNodeGenerator.getName(data));
        treeNode.setParentId(treeNodeGenerator.getParentId(data));
        if (StringUtils.isNotBlank((CharSequence)treeNodeAttributeMapper.getSortName())) {
            treeNode.setSort(treeNodeGenerator.getSort(data));
        }
        return treeNode;
    }

    public static <K, T> Map<String, Object> toMap(TreeNode<K, T> treeNode, TreeNodeAttributeMapper<T> treeAttributeMapper, Function<T, Object> extraFunction, boolean withData) {
        return TreeNode.toMapProcess(treeNode, treeAttributeMapper, withData, node -> TreeNode.toMap(node, treeAttributeMapper, extraFunction, withData), (data, map) -> {
            List extraMappingList = treeAttributeMapper.getExtraMappingList();
            if (CollectionUtils.isNotEmpty(extraMappingList) && Objects.nonNull(data)) {
                for (TreeNodeAttributeMapper.ExtraMapping extraMapping : extraMappingList) {
                    map.put(extraMapping.getExtraKeyName(), extraMapping.getExtraFunction().apply(data));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)treeAttributeMapper.getExtraName())) {
                if (Objects.nonNull(extraFunction) && Objects.nonNull(data)) {
                    map.put(treeAttributeMapper.getExtraName(), extraFunction.apply(data));
                } else {
                    map.put(treeAttributeMapper.getExtraName(), null);
                }
            }
        });
    }

    public static <K, T> Map<String, Object> toMapProcess(TreeNode<K, T> treeNode, TreeNodeAttributeMapper<T> treeAttributeMapper, boolean withData, Function<TreeNode<K, T>, Map<String, Object>> childrenNodeToMapFunction, BiConsumer<T, Map<String, Object>> extraConsumer) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Function<T, Object> overNodeIdFunction = treeAttributeMapper.getOverNodeIdFunction();
        T data = treeNode.getData();
        if (Objects.nonNull(overNodeIdFunction) && Objects.nonNull(data)) {
            map.put(treeAttributeMapper.getNodeIdName(), overNodeIdFunction.apply(data));
        } else {
            map.put(treeAttributeMapper.getNodeIdName(), treeNode.getId());
        }
        map.put(treeAttributeMapper.getNodeName(), treeNode.getName());
        map.put(treeAttributeMapper.getParentId(), treeNode.getParentId());
        if (StringUtils.isNotBlank((CharSequence)treeAttributeMapper.getSortName())) {
            map.put(treeAttributeMapper.getSortName(), treeNode.getSort());
        }
        if (CollectionUtils.isNotEmpty(treeNode.getChildren())) {
            map.put(treeAttributeMapper.getChildrenName(), treeNode.getChildren().stream().map(node -> (Map)childrenNodeToMapFunction.apply((TreeNode)node)).collect(Collectors.toList()));
        } else {
            map.put(treeAttributeMapper.getChildrenName(), null);
        }
        if (withData && StringUtils.isNotBlank((CharSequence)treeAttributeMapper.getDataName())) {
            map.put(treeAttributeMapper.getDataName(), data);
        }
        extraConsumer.accept(data, map);
        return map;
    }

    public K getId() {
        return this.id;
    }

    public K getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getData() {
        return this.data;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setId(K id) {
        this.id = id;
    }

    public void setParentId(K parentId) {
        this.parentId = parentId;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public void setChildren(List<TreeNode<K, T>> children) {
        this.children = children;
    }

    public List<TreeNode<K, T>> getChildren() {
        return this.children;
    }
}

