/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.model.request;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.GlobalInfo;
import cn.woodwhales.common.webhook.model.param.ExecuteParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseWebhookRequestBody {
    @JsonIgnore
    @Expose(serialize=false)
    protected WebhookProductEnum webhookProductEnum;
    @JsonIgnore
    @Expose(serialize=false)
    protected GlobalInfo globalInfo;
    @JsonIgnore
    @Expose(serialize=false)
    protected List<String> userIdList;
    @JsonIgnore
    @Expose(serialize=false)
    protected List<String> userMobileList;
    @JsonIgnore
    @Expose(serialize=false)
    protected Map<String, Object> map = new LinkedHashMap<String, Object>();

    public String toJsonSting() {
        List<Pair<String, String>> allInfoPair = this.globalInfo.getAllInfoPair(this.webhookProductEnum);
        allInfoPair.stream().forEach(pair -> this.map.put((String)pair.getLeft(), pair.getRight()));
        this.preToJsonSting();
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return gson.toJson((Object)this);
    }

    public abstract String getUrlAndSignContent(ExecuteParam var1);

    public BaseWebhookRequestBody addUserIdList(List<String> userIdList) {
        if (userIdList != null && userIdList.size() > 0) {
            this.userIdList = userIdList;
        }
        return this;
    }

    public BaseWebhookRequestBody addUserMobileList(List<String> userMobileList) {
        if (userMobileList != null && userMobileList.size() > 0) {
            this.userMobileList = userMobileList;
        }
        return this;
    }

    public abstract void preToJsonSting();

    public Map<String, Object> getMap() {
        return this.map;
    }

    public BaseWebhookRequestBody addContent(String tag, String text) {
        this.map.put(tag, text);
        return this;
    }

    public BaseWebhookRequestBody addContent(String tag, Object obj) {
        this.map.put(tag, obj);
        return this;
    }

    public BaseWebhookRequestBody addSign(long timestamp, String sign) {
        return this.addContent("sign", sign).addContent("timestamp", timestamp);
    }

    public void setWebhookProductEnum(WebhookProductEnum webhookProductEnum) {
        this.webhookProductEnum = webhookProductEnum;
    }

    public WebhookProductEnum getWebhookProductEnum() {
        return this.webhookProductEnum;
    }

    public BaseWebhookRequestBody addGlobalInfo(GlobalInfo globalInfo) {
        this.globalInfo = globalInfo;
        return this;
    }
}

