/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.validation;

import cn.woodwhales.common.validation.EnumValidator;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValidatorValidator
implements ConstraintValidator<EnumValidator, Object> {
    private static final Logger log = LoggerFactory.getLogger(EnumValidatorValidator.class);
    private List<Object> values = new ArrayList<Object>();

    public void initialize(EnumValidator enumValidator) {
        Class<? extends Enum>[] classArray = enumValidator.target();
        if (classArray.length == 0) {
            return;
        }
        try {
            this.addValue(classArray, enumValidator.methodName());
        }
        catch (Exception exception) {
            log.error("handle exception process happening exception! {}", (Throwable)exception);
        }
    }

    private void addValue(Class<? extends Enum>[] classArray, String methodString) throws Exception {
        for (Class<? extends Enum> clz : classArray) {
            if (!clz.isEnum()) continue;
            Enum[] objects = clz.getEnumConstants();
            Method method = clz.getMethod(methodString, new Class[0]);
            if (Objects.isNull(method)) {
                throw new RuntimeException(String.format("\u679a\u4e3e\u5bf9\u8c61%s\u7f3a\u5c11\u540d\u4e3a%s\u7684\u65b9\u6cd5", clz.getName(), methodString));
            }
            for (Enum obj : objects) {
                Object value = method.invoke((Object)obj, new Object[0]);
                this.values.add(value);
            }
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value instanceof String) {
            String valueStr = (String)value;
            return StringUtils.isEmpty((CharSequence)valueStr) || this.values.contains(value);
        }
        return Objects.isNull(value) || this.values.contains(value);
    }
}

