/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.model.vo;

import cn.woodwhales.common.model.enums.RespCodeEnum;
import cn.woodwhales.common.model.result.BaseRespResult;
import cn.woodwhales.common.model.vo.RespVO;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageRespVO<T> {
    private Long count;
    private List<T> list;

    public static <T> RespVO<PageRespVO<T>> success(Long count, List<T> data) {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, count, data);
    }

    public static <T> RespVO<PageRespVO<T>> success(List<T> data) {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, Long.parseLong(data.size() + ""), data);
    }

    public static <T> RespVO<PageRespVO<T>> empty() {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, 0L, null);
    }

    public static RespVO error(BaseRespResult baseRespResult) {
        return PageRespVO.buildPageRespVO(baseRespResult, 0L, null);
    }

    public static <T> RespVO<PageRespVO<T>> buildPageRespVO(IPage<T> page) {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), page.getRecords());
    }

    public static <S, T> RespVO<PageRespVO<T>> buildPageRespVO(IPage<S> page, Function<? super S, ? extends T> mapper) {
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), Collections.emptyList());
        }
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), page.getRecords().stream().map(mapper).collect(Collectors.toList()));
    }

    public static <S, T> RespVO<PageRespVO<T>> buildPageRespVO(IPage<S> page, Function<? super S, ? extends T> mapper, Comparator<T> comparator) {
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), Collections.emptyList());
        }
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), page.getRecords().stream().map(mapper).sorted(comparator).collect(Collectors.toList()));
    }

    public static <T> RespVO<PageRespVO<T>> buildPageRespVO(@NotNull BaseRespResult baseRespResult, Long count, List<T> data) {
        Objects.requireNonNull(baseRespResult, "baseRespResult\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        return PageRespVO.build(baseRespResult.getCode(), baseRespResult.getMessage(), count, data);
    }

    private static <T> RespVO<PageRespVO<T>> build(Integer code, String message, Long count, List<T> data) {
        Objects.requireNonNull(code, "code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        RespVO<PageRespVO<PageRespVO<T>>> respVO = new RespVO<PageRespVO<PageRespVO<T>>>();
        respVO.setCode(code);
        respVO.setMsg(message);
        PageRespVO<T> pageRespVO = new PageRespVO<T>();
        if (CollectionUtils.isEmpty(data)) {
            pageRespVO.setCount(0L);
            pageRespVO.setList(Collections.emptyList());
        } else {
            pageRespVO.setCount(count);
            pageRespVO.setList(data);
        }
        respVO.setData(pageRespVO);
        return respVO;
    }

    public Long getCount() {
        return this.count;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRespVO)) {
            return false;
        }
        PageRespVO other = (PageRespVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRespVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageRespVO(count=" + this.getCount() + ", list=" + this.getList() + ")";
    }
}

