/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.file;

import cn.woodwhales.common.file.FileEncryptTool;
import cn.woodwhales.common.file.FileTypeHexStrEnum;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

class FileEncryptToolExample {
    private static String originFileName;
    private static String originFileParentAbsolutePath;

    FileEncryptToolExample() {
    }

    public static void main(String[] args) {
        FileEncryptToolExample.testEncoder();
        FileEncryptToolExample.testDecode();
    }

    private static void init() {
        URL resource = FileEncryptToolExample.class.getClassLoader().getResource("test.png");
        originFileName = resource.getFile();
        File parentFile = new File(originFileName).getParentFile();
        originFileParentAbsolutePath = parentFile.getAbsolutePath();
    }

    public static void testEncoder() {
        FileEncryptToolExample.init();
        String encodeFileName = FileEncryptTool.encodeFileToPng(originFileName);
        FileEncryptToolExample.assertEquals("test_89504E47_504b0304_zip.PNG", StringUtils.substringAfterLast((String)encodeFileName, (String)File.separator));
    }

    public static void testDecode() {
        FileEncryptToolExample.init();
        String encodeFileName = FileEncryptTool.encodeFile(originFileName, FileTypeHexStrEnum.PNG);
        String decodeFileName = FileEncryptTool.decodeFile(encodeFileName);
        FileEncryptToolExample.assertEquals(originFileParentAbsolutePath + File.separator + "test", decodeFileName);
    }

    private static void assertEquals(Object expected, Object actual) {
        boolean b = FileEncryptToolExample.objectsAreEqual(expected, actual);
        if (!b) {
            throw new RuntimeException("\nexpected = " + expected + ", actual = " + actual);
        }
    }

    private static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

