/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business.collection;

import cn.woodwhales.common.business.collection.CollectionFieldComparable;
import java.util.Objects;
import java.util.function.Function;

public class CollectionContainer<K, T>
implements CollectionFieldComparable<K> {
    private T data;
    private K dataKey;

    public CollectionContainer(T data, K dataKey) {
        this.data = data;
        this.dataKey = dataKey;
    }

    public T getData() {
        return this.data;
    }

    @Override
    public K getDataKey() {
        return this.dataKey;
    }

    public static <K, T> CollectionContainer<K, T> build(T data, Function<T, K> keyFunction) {
        return new CollectionContainer<K, T>(data, keyFunction.apply(data));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectionContainer)) {
            return false;
        }
        CollectionContainer that = (CollectionContainer)o;
        return this.getDataKey().equals(that.getDataKey());
    }

    public int hashCode() {
        return Objects.hash(this.getDataKey());
    }

    public String toString() {
        return "CollectionContainer{data=" + this.data + ", dataKey=" + this.dataKey + '}';
    }
}

