/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business.chinese;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.business.chinese.ChineseDataTool;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class ChineseDataContainer<T> {
    private T data;
    private String field;

    public ChineseDataContainer(T data, Function<T, String> stringFunction) {
        Preconditions.checkNotNull(data);
        Preconditions.checkNotNull(stringFunction);
        this.data = data;
        this.field = stringFunction.apply(data);
    }

    public static <T> List<ChineseDataContainer<T>> build(List<T> dataList, Function<T, String> stringFunction) {
        return DataTool.toList(dataList, data -> new ChineseDataContainer<Object>(data, stringFunction));
    }

    public int compare(ChineseDataContainer chineseDataContainer) {
        return ComparisonChain.start().compare((Object)this.field, (Object)chineseDataContainer.getField(), (Comparator)ChineseDataTool.collator).result();
    }

    public T getData() {
        return this.data;
    }

    public String getField() {
        return this.field;
    }
}

