/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.model.request;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.request.DingTalkRequestBody;
import cn.woodwhales.common.webhook.model.request.FeiShuRequestBody;
import cn.woodwhales.common.webhook.model.request.WeComRequestBody;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class WebhookRequestBodyFactory {
    public static BaseWebhookRequestBody newInstance(WebhookProductEnum webhookProductEnum, String title, Consumer<BaseWebhookRequestBody> consumer, List<String> userIdList, List<String> userMobileList) {
        BaseWebhookRequestBody requestBody = null;
        switch (webhookProductEnum) {
            case WE_COM: {
                requestBody = WeComRequestBody.newInstance(title);
                requestBody.addUserMobileList(userMobileList);
                requestBody.addUserIdList(userIdList);
                break;
            }
            case DING_TALK: {
                requestBody = DingTalkRequestBody.newInstance(title);
                requestBody.addUserMobileList(userMobileList);
                requestBody.addUserIdList(userIdList);
                break;
            }
            case FEI_SHU: {
                requestBody = FeiShuRequestBody.newInstance(title);
                requestBody.addUserIdList(userIdList);
            }
        }
        requestBody.setWebhookProductEnum(webhookProductEnum);
        if (Objects.nonNull(consumer)) {
            consumer.accept(requestBody);
        }
        return requestBody;
    }
}

