/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.model.request;

import cn.woodwhales.common.webhook.model.param.ExecuteParam;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import com.google.gson.annotations.Expose;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeiShuRequestBody
extends BaseWebhookRequestBody {
    private static final Logger log = LoggerFactory.getLogger(FeiShuRequestBody.class);
    @Expose
    private String msg_type = "post";
    @Expose
    private ContentDTO content;
    @Expose
    protected String sign;
    @Expose
    protected String timestamp;

    public static FeiShuRequestBody newInstance(String title) {
        LinkedList<List<BaseContentItemDTO>> content = new LinkedList<List<BaseContentItemDTO>>();
        PostContentDTO postContentDTO = new PostContentDTO(title, content);
        LanguageContentDTO languageContentDTO = new LanguageContentDTO(postContentDTO);
        ContentDTO contentDTO = new ContentDTO(languageContentDTO);
        FeiShuRequestBody feiShuNoticeRequestBody = new FeiShuRequestBody(contentDTO);
        return feiShuNoticeRequestBody;
    }

    @Override
    public String getUrlAndSignContent(ExecuteParam executeParam) {
        Long timestamp = Long.parseLong(StringUtils.substring((String)(System.currentTimeMillis() + ""), (int)0, (int)10));
        String sign = this.generateSign(executeParam.getSecret(), timestamp, executeParam.getRequestBody());
        this.timestamp = timestamp.toString();
        this.sign = sign;
        return executeParam.getUrl();
    }

    @Override
    public void preToJsonSting() {
        LinkedList<List<BaseContentItemDTO>> contentList = this.getContent().getPost().getZh_cn().getContent();
        this.map.entrySet().stream().forEach(entry -> {
            ArrayList<ContentItemDTO> list = new ArrayList<ContentItemDTO>();
            list.add(new ContentItemDTO((String)entry.getKey()));
            list.add(new ContentItemDTO((String)entry.getValue()));
            contentList.add(list);
        });
        List<BaseContentItemDTO> baseContentItemDTOS = contentList.get(0);
        if (this.userIdList != null && this.userIdList.size() > 0) {
            baseContentItemDTOS.addAll(this.userIdList.stream().map(ContentUserItemDTO::new).collect(Collectors.toList()));
        }
    }

    private String generateSign(String secret, long timestamp, BaseWebhookRequestBody requestBody) {
        String stringToSign = timestamp + "\n" + secret;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(stringToSign.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal();
            return Base64.getEncoder().encodeToString(signData);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u5931\u8d25");
            return "";
        }
    }

    public FeiShuRequestBody(ContentDTO content) {
        this.content = content;
    }

    private FeiShuRequestBody() {
    }

    public String getMsg_type() {
        return this.msg_type;
    }

    public ContentDTO getContent() {
        return this.content;
    }

    public String getSign() {
        return this.sign;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setMsg_type(String msg_type) {
        this.msg_type = msg_type;
    }

    public void setContent(ContentDTO content) {
        this.content = content;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeiShuRequestBody)) {
            return false;
        }
        FeiShuRequestBody other = (FeiShuRequestBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msg_type = this.getMsg_type();
        String other$msg_type = other.getMsg_type();
        if (this$msg_type == null ? other$msg_type != null : !this$msg_type.equals(other$msg_type)) {
            return false;
        }
        ContentDTO this$content = this.getContent();
        ContentDTO other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeiShuRequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msg_type = this.getMsg_type();
        result = result * 59 + ($msg_type == null ? 43 : $msg_type.hashCode());
        ContentDTO $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    public String toString() {
        return "FeiShuRequestBody(msg_type=" + this.getMsg_type() + ", content=" + this.getContent() + ", sign=" + this.getSign() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class ContentUserItemDTO
    extends BaseContentItemDTO {
        @Expose
        private String tag = "at";
        @Expose
        private String user_id;

        public ContentUserItemDTO(String user_id) {
            this.user_id = user_id;
        }

        public String getTag() {
            return this.tag;
        }

        public String getUser_id() {
            return this.user_id;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setUser_id(String user_id) {
            this.user_id = user_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentUserItemDTO)) {
                return false;
            }
            ContentUserItemDTO other = (ContentUserItemDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$user_id = this.getUser_id();
            String other$user_id = other.getUser_id();
            return !(this$user_id == null ? other$user_id != null : !this$user_id.equals(other$user_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentUserItemDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $user_id = this.getUser_id();
            result = result * 59 + ($user_id == null ? 43 : $user_id.hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuRequestBody.ContentUserItemDTO(tag=" + this.getTag() + ", user_id=" + this.getUser_id() + ")";
        }
    }

    public static class BaseContentItemDTO {
    }

    public static class ContentItemDTO
    extends BaseContentItemDTO {
        @Expose
        private String tag = "text";
        @Expose
        private String text;

        public ContentItemDTO(String text) {
            this.text = text;
        }

        public String getTag() {
            return this.tag;
        }

        public String getText() {
            return this.text;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentItemDTO)) {
                return false;
            }
            ContentItemDTO other = (ContentItemDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentItemDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuRequestBody.ContentItemDTO(tag=" + this.getTag() + ", text=" + this.getText() + ")";
        }
    }

    private static class PostContentDTO {
        @Expose
        private String title;
        @Expose
        private LinkedList<List<BaseContentItemDTO>> content;

        public PostContentDTO(String title, LinkedList<List<BaseContentItemDTO>> content) {
            this.title = title;
            this.content = content;
        }

        public String getTitle() {
            return this.title;
        }

        public LinkedList<List<BaseContentItemDTO>> getContent() {
            return this.content;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setContent(LinkedList<List<BaseContentItemDTO>> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PostContentDTO)) {
                return false;
            }
            PostContentDTO other = (PostContentDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            LinkedList<List<BaseContentItemDTO>> this$content = this.getContent();
            LinkedList<List<BaseContentItemDTO>> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PostContentDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            LinkedList<List<BaseContentItemDTO>> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuRequestBody.PostContentDTO(title=" + this.getTitle() + ", content=" + this.getContent() + ")";
        }
    }

    private static class LanguageContentDTO {
        @Expose
        private PostContentDTO zh_cn;

        public LanguageContentDTO(PostContentDTO zh_cn) {
            this.zh_cn = zh_cn;
        }

        public PostContentDTO getZh_cn() {
            return this.zh_cn;
        }

        public void setZh_cn(PostContentDTO zh_cn) {
            this.zh_cn = zh_cn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LanguageContentDTO)) {
                return false;
            }
            LanguageContentDTO other = (LanguageContentDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PostContentDTO this$zh_cn = this.getZh_cn();
            PostContentDTO other$zh_cn = other.getZh_cn();
            return !(this$zh_cn == null ? other$zh_cn != null : !((Object)this$zh_cn).equals(other$zh_cn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LanguageContentDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PostContentDTO $zh_cn = this.getZh_cn();
            result = result * 59 + ($zh_cn == null ? 43 : ((Object)$zh_cn).hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuRequestBody.LanguageContentDTO(zh_cn=" + this.getZh_cn() + ")";
        }
    }

    private static class ContentDTO {
        @Expose
        private LanguageContentDTO post;

        public ContentDTO(LanguageContentDTO post) {
            this.post = post;
        }

        public LanguageContentDTO getPost() {
            return this.post;
        }

        public void setPost(LanguageContentDTO post) {
            this.post = post;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentDTO)) {
                return false;
            }
            ContentDTO other = (ContentDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LanguageContentDTO this$post = this.getPost();
            LanguageContentDTO other$post = other.getPost();
            return !(this$post == null ? other$post != null : !((Object)this$post).equals(other$post));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LanguageContentDTO $post = this.getPost();
            result = result * 59 + ($post == null ? 43 : ((Object)$post).hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuRequestBody.ContentDTO(post=" + this.getPost() + ")";
        }
    }
}

