/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.file;

import cn.hutool.core.util.ZipUtil;
import cn.woodwhales.common.file.FileTypeHexStrEnum;
import java.io.File;
import java.io.RandomAccessFile;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class FileEncryptTool {
    public static String encodeFileToPng(String originFileName) {
        return FileEncryptTool.encodeFile(originFileName, FileTypeHexStrEnum.PNG);
    }

    public static String encodeFile(String originFileName, FileTypeHexStrEnum fileTypeHexStrEnum) {
        File originFile = new File(originFileName);
        if (!originFile.exists()) {
            throw new RuntimeException(originFile + " \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String suffix = StringUtils.substringAfterLast((String)originFileName, (String)".");
        String fileName = StringUtils.substringBeforeLast((String)originFileName, (String)".");
        if (!StringUtils.equalsIgnoreCase((CharSequence)suffix, (CharSequence)"zip")) {
            File zipFile = ZipUtil.zip((String)originFileName, (String)(fileName + ".zip"));
            originFileName = zipFile.getAbsolutePath();
        }
        return FileEncryptTool.encode(originFileName, fileTypeHexStrEnum.hexStr, fileTypeHexStrEnum.suffix);
    }

    public static String decodeFile(String encodeOriginFileName) {
        String decodeZipFile = FileEncryptTool.decode(encodeOriginFileName);
        File unzipFile = ZipUtil.unzip((String)decodeZipFile);
        return unzipFile.getAbsolutePath();
    }

    private FileEncryptTool() {
    }

    private static String encode(String originFileName, String encodeHexStr, String encodeSuffix) {
        File originFile = new File(originFileName);
        if (!originFile.exists()) {
            throw new RuntimeException(originFile + " \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String subOriginFileName = StringUtils.substringBeforeLast((String)originFileName, (String)".");
        String subOriginFileSuffix = StringUtils.substringAfterLast((String)originFileName, (String)".");
        String originHexStr = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(originFile, "rw");){
            byte[] buffer = new byte[4];
            randomAccessFile.seek(0L);
            randomAccessFile.read(buffer, 0, buffer.length);
            originHexStr = Hex.encodeHexString((byte[])buffer);
            byte[] fillBuffer = Hex.decodeHex((String)encodeHexStr);
            randomAccessFile.seek(0L);
            randomAccessFile.write(fillBuffer, 0, fillBuffer.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String encodedFileName = "" + subOriginFileName + "_" + encodeHexStr + "_" + originHexStr + "_" + subOriginFileSuffix + "." + encodeSuffix;
        originFile.renameTo(new File(encodedFileName));
        return encodedFileName;
    }

    private static String decode(String encodeOriginFileName) {
        File encodeOriginFile = new File(encodeOriginFileName);
        if (!encodeOriginFile.exists()) {
            new RuntimeException(encodeOriginFileName + " \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String encodeOriginFileNameWithoutSuffix = StringUtils.substringBeforeLast((String)encodeOriginFileName, (String)".");
        String encodeOriginFileNameSuffix = StringUtils.substringAfterLast((String)encodeOriginFileName, (String)".");
        String[] split = StringUtils.split((String)encodeOriginFileNameWithoutSuffix, (String)"_");
        String originFileSuffix = split[split.length - 1];
        String decodeHexStr = split[split.length - 2];
        String encodedHexStr = split[split.length - 3];
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(encodeOriginFile, "rw");){
            byte[] fillBytes = Hex.decodeHex((String)decodeHexStr);
            randomAccessFile.seek(0L);
            randomAccessFile.write(fillBytes, 0, fillBytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String tempStr = "_" + encodedHexStr + "_" + decodeHexStr + "_" + originFileSuffix + "." + encodeOriginFileNameSuffix;
        String newFileName = StringUtils.replace((String)encodeOriginFileName, (String)tempStr, (String)("." + originFileSuffix));
        encodeOriginFile.renameTo(new File(newFileName));
        return newFileName;
    }
}

