/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.business.tree;

import cn.woodwhales.common.business.tree.TreeNode;
import cn.woodwhales.common.business.tree.TreeNodeAttributeMapper;
import cn.woodwhales.common.business.tree.TreeTool;
import cn.woodwhales.common.example.model.business.tree.MyTreeNodeGenerator;
import cn.woodwhales.common.example.model.business.tree.TreeToolTempMenu;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TreeToolExample {
    private static List<TreeToolTempMenu> testList;

    public static void init() {
        ArrayList list = Lists.newArrayListWithCapacity((int)6);
        list.add(new TreeToolTempMenu(9, null, "\u4e0a\u6d77", 30));
        list.add(new TreeToolTempMenu(1, null, "\u5317\u4eac", 10));
        list.add(new TreeToolTempMenu(2, 1, "\u6d77\u6dc0", 1));
        list.add(new TreeToolTempMenu(4, 1, "\u897f\u57ce", 3));
        list.add(new TreeToolTempMenu(3, 1, "\u671d\u9633", 2));
        list.add(new TreeToolTempMenu(9, 1, "\u4e1c\u57ce", 0));
        list.add(new TreeToolTempMenu(5, null, "\u5b89\u5fbd", 20));
        list.add(new TreeToolTempMenu(6, 5, "\u5408\u80a5", 1));
        list.add(new TreeToolTempMenu(7, 5, "\u5b89\u5e86", 2));
        list.add(new TreeToolTempMenu(8, 5, "\u9ec4\u5c71", 3));
        testList = list;
    }

    public static void main(String[] args) {
        TreeToolExample.test1();
        TreeToolExample.test2();
        TreeToolExample.test3();
        TreeToolExample.test4();
        TreeToolExample.test5();
    }

    public static void test1() {
        TreeToolExample.init();
        List<TreeNode<Integer, TreeToolTempMenu>> tree1 = TreeTool.tree(testList, new MyTreeNodeGenerator());
        TreeToolExample.print(tree1);
    }

    public static void test2() {
        TreeToolExample.init();
        List<Map<String, Object>> tree2 = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeId("key").childrenName("child").parentId("fatherId").sortName("weight").build());
        TreeToolExample.print(tree2);
    }

    public static void test3() {
        TreeToolExample.init();
        List<TreeNode<Integer, TreeToolTempMenu>> tree3 = TreeTool.tree(testList, new MyTreeNodeGenerator(), true);
        TreeToolExample.print(tree3);
    }

    public static void test4() {
        TreeToolExample.init();
        List<Map<String, Object>> tree4 = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeId("key").nodeName("key").childrenName("child").parentId("fatherId").sortName("weight").dataName("origin").build(), true);
        TreeToolExample.print(tree4);
    }

    public static void test5() {
        TreeToolExample.init();
        List<Map<String, Object>> tree5 = TreeTool.tree(testList, new MyTreeNodeGenerator(), TreeNodeAttributeMapper.builder().nodeId("key").overNodeId(TreeToolTempMenu::getCityName).build(), true);
        TreeToolExample.print(tree5);
    }

    private static void print(Object object) {
        System.out.println("data => " + new Gson().toJson(object));
    }
}

