/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.executor;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.param.ExecuteParam;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.response.ExecuteResponse;
import com.google.gson.Gson;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWebhookExecutor<RequestBody extends BaseWebhookRequestBody, Response> {
    private static final Logger log = LoggerFactory.getLogger(BaseWebhookExecutor.class);

    protected void beforeHandler(ExecuteParam executeParam) {
    }

    protected void afterHandler(ExecuteParam executeParam, ExecuteResponse<Response> executeResponse) {
    }

    protected abstract boolean checkResponseObjectHandler(ExecuteResponse<Response> var1);

    protected Response parseResponseHandler(ExecuteResponse<Response> executeResponse) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)genericSuperclass.getActualTypeArguments()[1];
        return (Response)new Gson().fromJson(executeResponse.originResponseContent, clazz);
    }

    protected void checkFailHandler(ExecuteResponse<Response> executeResponse) {
        log.error("{}\u53d1\u9001\u6d88\u606f\u5931\u8d25, url = {}, requestContent = {}, originResponseContent = {}", new Object[]{this.webhookProductEnum().chineseName, executeResponse.url, executeResponse.requestContent, executeResponse.originResponseContent});
    }

    protected void checkSuccessHandler(ExecuteResponse<Response> executeResponse) {
        log.info("{}\u53d1\u9001\u6d88\u606f\u6210\u529f, url = {}, requestContent = {}, originResponseContent = {}", new Object[]{this.webhookProductEnum().chineseName, executeResponse.url, executeResponse.requestContent, executeResponse.originResponseContent});
    }

    protected abstract WebhookProductEnum webhookProductEnum();

    protected void execute(ExecuteParam executeParam) {
        this.beforeHandler(executeParam);
        ExecuteResponse<Response> executeResponse = this.executeRequest(executeParam);
        executeResponse.parsedResponseObject = this.parseResponseHandler(executeResponse);
        executeResponse.checkResult = this.checkResponseObjectHandler(executeResponse);
        if (!executeResponse.checkResult) {
            this.checkFailHandler(executeResponse);
        } else {
            this.checkSuccessHandler(executeResponse);
        }
        this.afterHandler(executeParam, executeResponse);
    }

    private ExecuteResponse<Response> executeRequest(ExecuteParam executeParam) {
        ExecuteResponse executeResponse = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String noticeUrl = executeParam.getNoticeUrl();
            HttpPost post = new HttpPost(noticeUrl);
            post.setHeader("Accept", "aplication/json");
            post.setHeader("Content-Type", "application/json;charset=UTF-8");
            String noticeContent = executeParam.getNoticeContent();
            StringEntity se = new StringEntity(noticeContent, StandardCharsets.UTF_8);
            se.setContentEncoding("UTF-8");
            se.setContentType("application/json");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String originResponseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            executeResponse = new ExecuteResponse(noticeUrl, noticeContent, statusCode, originResponseContent);
        }
        catch (Exception e) {
            log.error("{}\u53d1\u9001\u6d88\u606f\u5931\u8d25, \u5f02\u5e38\u539f\u56e0\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return executeResponse;
    }

    public void execute(String url, RequestBody requestBody) {
        this.execute(url, null, requestBody);
    }

    public void execute(String url, String secret, RequestBody requestBody) {
        if (Objects.nonNull(requestBody)) {
            this.execute(ExecuteParam.newInstance(url, secret, requestBody));
        } else {
            log.warn("dingTalkRequestBody is NULL");
        }
    }

    protected Response getParsedResponse(ExecuteResponse<Response> executeResponse) {
        return (Response)executeResponse.parsedResponseObject;
    }
}

