/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.event;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.GlobalInfo;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.request.WebhookRequestBodyFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.springframework.context.ApplicationEvent;

public class WebhookEvent
extends ApplicationEvent {
    private String noticeUrl;
    private String secret;
    private String[] basePackageNames;
    private GlobalInfo globalInfo;
    private String title;
    private BaseWebhookRequestBody baseWebhookRequestBody;
    private WebhookProductEnum webhookProductEnum;
    private Consumer<BaseWebhookRequestBody> consumer;
    private Throwable throwable;
    private List<String> userIdList;
    private List<String> userMobileList;

    public WebhookEvent(Object source, Throwable throwable, String[] basePackageNames, String title, String noticeUrl, String secret, Consumer<BaseWebhookRequestBody> consumer, List<String> userIdList, List<String> userMobileList) {
        super(source);
        this.title = title;
        this.noticeUrl = noticeUrl;
        this.secret = secret;
        this.consumer = consumer;
        this.throwable = throwable;
        this.basePackageNames = basePackageNames;
        if (userIdList != null && userIdList.size() > 0) {
            this.userIdList = userIdList;
        }
        if (userMobileList != null && userMobileList.size() > 0) {
            this.userMobileList = userMobileList;
        }
        this.fillField();
    }

    private void fillField() {
        if (Objects.nonNull(this.noticeUrl)) {
            this.webhookProductEnum = WebhookProductEnum.getWebhookProductEnumByNoticeUrl(this.noticeUrl);
            this.globalInfo = new GlobalInfo(this.webhookProductEnum, this.throwable, this.basePackageNames, null);
            this.baseWebhookRequestBody = WebhookRequestBodyFactory.newInstance(this.webhookProductEnum, this.title, this.consumer, this.getUserIdList(), this.userMobileList);
        }
        if (Objects.nonNull(this.baseWebhookRequestBody) && Objects.nonNull(this.consumer)) {
            this.consumer.accept(this.baseWebhookRequestBody);
        }
    }

    public WebhookProductEnum getWebhookProductEnum() {
        return this.webhookProductEnum;
    }

    public void setMachineInfoMap(LinkedHashMap<String, String> machineInfoMap) {
        this.globalInfo.setMachineInfoMap(machineInfoMap);
    }

    public void setGitProperties(Properties gitProperties) {
        this.globalInfo.setGitProperties(gitProperties);
    }

    public String getOccurTime() {
        return this.globalInfo.getOccurTime();
    }

    public BaseWebhookRequestBody getBaseWebhookRequestBody() {
        return this.baseWebhookRequestBody;
    }

    public String getTitle() {
        return this.title;
    }

    public String getNoticeUrl() {
        return this.noticeUrl;
    }

    public void setNoticeUrl(String noticeUrl) {
        this.noticeUrl = noticeUrl;
        this.fillField();
    }

    public String getSecret() {
        return this.secret;
    }

    public String[] getBasePackageNames() {
        return this.basePackageNames;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public List<String> getUserIdList() {
        return this.userIdList;
    }

    public List<String> getUserMobileList() {
        return this.userMobileList;
    }

    public static class Builder {
        private Object source;
        private String title;
        private Throwable throwable;
        private String[] basePackageNames;
        private String noticeUrl;
        private String secret;
        private Consumer<BaseWebhookRequestBody> consumer;
        private List<String> userIdList;
        private List<String> userMobileList;

        public static Builder build(Object source, String title) {
            Builder builder = new Builder();
            builder.source = source;
            builder.title = title;
            return builder;
        }

        public Builder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public Builder throwable(Throwable throwable, String ... basePackageNames) {
            this.throwable = throwable;
            this.basePackageNames = basePackageNames;
            return this;
        }

        public Builder basePackageNames(String ... basePackageNames) {
            this.basePackageNames = basePackageNames;
            return this;
        }

        public Builder consumer(Consumer<BaseWebhookRequestBody> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder userIdList(List<String> userIdList) {
            this.userIdList = userIdList;
            return this;
        }

        public Builder userMobileList(List<String> userMobileList) {
            this.userMobileList = userMobileList;
            return this;
        }

        public Builder noticeUrl(String noticeUrl) {
            this.noticeUrl = noticeUrl;
            return this;
        }

        public Builder noticeUrl(String noticeUrl, String secret) {
            this.noticeUrl = noticeUrl;
            this.secret = secret;
            return this;
        }

        public WebhookEvent build() {
            return new WebhookEvent(this.source, this.throwable, this.basePackageNames, this.title, this.noticeUrl, this.secret, this.consumer, this.userIdList, this.userMobileList);
        }
    }
}

