/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.enums;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebhookProductEnum
extends Enum<WebhookProductEnum> {
    public static final /* enum */ WebhookProductEnum WE_COM;
    public static final /* enum */ WebhookProductEnum DING_TALK;
    public static final /* enum */ WebhookProductEnum FEI_SHU;
    private static final Logger log;
    public final String code;
    public final int limitContentLength;
    public final String chineseName;
    public final String host;
    private static final Map<String, WebhookProductEnum> hostMap;
    private static final /* synthetic */ WebhookProductEnum[] $VALUES;

    public static WebhookProductEnum[] values() {
        return (WebhookProductEnum[])$VALUES.clone();
    }

    public static WebhookProductEnum valueOf(String name) {
        return Enum.valueOf(WebhookProductEnum.class, name);
    }

    private WebhookProductEnum(String code, String chineseName, int limitContentLength, String host) {
        this.code = code;
        this.limitContentLength = limitContentLength;
        this.chineseName = chineseName;
        this.host = host;
    }

    public static WebhookProductEnum getWebhookProductEnumByNoticeUrl(String noticeUrl) {
        try {
            URL url = new URL(noticeUrl);
            String host = url.getHost();
            return hostMap.get(host);
        }
        catch (MalformedURLException e) {
            log.error("noticeUrl=[{}], \u914d\u7f6e\u975e\u6cd5", (Object)noticeUrl);
            return null;
        }
    }

    static {
        WebhookProductEnum[] webhookProductEnums;
        WE_COM = new WebhookProductEnum("WE_COM", "\u4f01\u4e1a\u5fae\u4fe1", 1365, "qyapi.weixin.qq.com");
        DING_TALK = new WebhookProductEnum("DING_TALK", "\u9489\u9489", 1365, "oapi.dingtalk.com");
        FEI_SHU = new WebhookProductEnum("FEI_SHU", "\u98de\u4e66", 6666, "open.feishu.cn");
        $VALUES = new WebhookProductEnum[]{WE_COM, DING_TALK, FEI_SHU};
        log = LoggerFactory.getLogger(WebhookProductEnum.class);
        hostMap = new HashMap<String, WebhookProductEnum>();
        for (WebhookProductEnum webhookProductEnum : webhookProductEnums = WebhookProductEnum.values()) {
            hostMap.put(webhookProductEnum.host, webhookProductEnum);
        }
    }
}

