/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.model.vo;

import cn.woodwhales.common.model.enums.RespCodeEnum;
import cn.woodwhales.common.model.result.BaseRespResult;
import cn.woodwhales.common.model.result.OpResult;
import java.util.Objects;
import java.util.function.Function;
import javax.validation.constraints.NotNull;

public class RespVO<T> {
    private Integer code;
    private String msg;
    private T data;

    public static <T> RespVO<T> success() {
        return RespVO.build(RespCodeEnum.SUCCESS, null);
    }

    public static <T> RespVO<T> success(T data) {
        return RespVO.build(RespCodeEnum.SUCCESS, data);
    }

    public static <T> RespVO<T> error() {
        return RespVO.build(RespCodeEnum.ERROR, null);
    }

    public static <T> RespVO<T> error(BaseRespResult baseRespResult) {
        return RespVO.buildWithBaseRespResult(baseRespResult, null);
    }

    public static <T> RespVO<T> error(BaseRespResult baseRespResult, T data) {
        return RespVO.buildWithBaseRespResult(baseRespResult, data);
    }

    public static <T> RespVO<T> buildWithBaseRespResult(BaseRespResult baseRespResult) {
        return RespVO.buildWithBaseRespResult(baseRespResult, null);
    }

    public static <T> RespVO<T> errorWithErrorMsg(String errorMsg) {
        return RespVO.errorWithErrorMsg(RespCodeEnum.ERROR, errorMsg);
    }

    public static <T> RespVO<T> errorWithErrorMsg(BaseRespResult baseRespResult, String errorMsg) {
        Objects.requireNonNull(baseRespResult);
        return RespVO.build(baseRespResult.getCode(), errorMsg, null);
    }

    public static <T> RespVO<T> buildWithBaseRespResult(BaseRespResult baseRespResult, T data) {
        Objects.requireNonNull(baseRespResult);
        return RespVO.build(baseRespResult.getCode(), baseRespResult.getMessage(), data);
    }

    public static <S, T> RespVO<T> resp(OpResult<S> opResult, @NotNull Function<S, T> function) {
        Objects.requireNonNull(function, "\u5bf9\u8c61\u8f6c\u6362\u63a5\u53e3\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (opResult.isSuccessful()) {
            return RespVO.success(function.apply(opResult.getData()));
        }
        BaseRespResult baseRespResult = opResult.getBaseRespResult();
        return RespVO.error(baseRespResult, function.apply(opResult.getData()));
    }

    public static <T> RespVO<T> resp(OpResult<T> opResult) {
        if (opResult.isSuccessful()) {
            return RespVO.success(opResult.getData());
        }
        BaseRespResult baseRespResult = opResult.getBaseRespResult();
        return RespVO.error(baseRespResult, opResult.getData());
    }

    private static <T> RespVO<T> build(Integer code, String message, T data) {
        RespVO<T> respVO = new RespVO<T>();
        respVO.setCode(code);
        respVO.setMsg(message);
        respVO.setData(data);
        return respVO;
    }

    private static <T> RespVO<T> build(RespCodeEnum respCodeEnum, T data) {
        return RespVO.buildWithBaseRespResult(respCodeEnum, data);
    }

    public static <T> RespVOBuilder<T> builder() {
        return new RespVOBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RespVO)) {
            return false;
        }
        RespVO other = (RespVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RespVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "RespVO(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public RespVO() {
    }

    public RespVO(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static class RespVOBuilder<T> {
        private Integer code;
        private String msg;
        private T data;

        RespVOBuilder() {
        }

        public RespVOBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public RespVOBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public RespVOBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public RespVO<T> build() {
            return new RespVO<T>(this.code, this.msg, this.data);
        }

        public String toString() {
            return "RespVO.RespVOBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

