/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.model.result;

import cn.woodwhales.common.model.enums.RespCodeEnum;
import cn.woodwhales.common.model.result.BaseRespResult;
import java.util.Objects;

public class OpResult<T> {
    private BaseRespResult baseRespResult;
    private T data;

    public static <T> OpResult<T> success(T data) {
        return new OpResult<T>(RespCodeEnum.SUCCESS, data);
    }

    public static <T> OpResult<T> success() {
        return new OpResult<Object>(RespCodeEnum.SUCCESS, null);
    }

    public static <T> OpResult<T> failure() {
        return new OpResult<Object>(RespCodeEnum.ERROR, null);
    }

    public static <T> OpResult<T> failure(BaseRespResult baseRespResult) {
        return new OpResult<Object>(baseRespResult, null);
    }

    public static <T> OpResult<T> failure(BaseRespResult baseRespResult, T data) {
        return new OpResult<T>(baseRespResult, data);
    }

    public T getData() {
        return this.data;
    }

    public BaseRespResult getBaseRespResult() {
        return this.baseRespResult;
    }

    public boolean dataIsNull() {
        return Objects.isNull(this.data);
    }

    public boolean dataIsNonNull() {
        return Objects.nonNull(this.data);
    }

    public boolean isSuccessful() {
        return Objects.equals(this.baseRespResult.getCode(), RespCodeEnum.SUCCESS.getCode());
    }

    public boolean isFailure() {
        return !this.isSuccessful();
    }

    private OpResult() {
    }

    private OpResult(BaseRespResult baseRespResult, T data) {
        this.baseRespResult = baseRespResult;
        this.data = data;
    }
}

