/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.model.request;

import cn.woodwhales.common.util.JsonUtils;
import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.GlobalInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseWebhookRequestBody {
    @JsonIgnore
    protected WebhookProductEnum webhookProductEnum;
    @JsonIgnore
    protected GlobalInfo globalInfo;
    @JsonIgnore
    protected List<String> userIdList;
    @JsonIgnore
    protected List<String> userMobileList;
    @JsonIgnore
    protected Map<String, Object> map = new LinkedHashMap<String, Object>();

    public String toJsonSting() {
        List<Pair<String, String>> allInfoPair = this.globalInfo.getAllInfoPair();
        allInfoPair.stream().forEach(pair -> this.map.put((String)pair.getLeft(), pair.getRight()));
        this.preToJsonSting();
        return JsonUtils.toJson(this);
    }

    protected BaseWebhookRequestBody addUserIdList(List<String> userIdList) {
        if (userIdList != null && userIdList.size() > 0) {
            this.userIdList = userIdList;
        }
        return this;
    }

    protected BaseWebhookRequestBody addUserMobileList(List<String> userMobileList) {
        if (userMobileList != null && userMobileList.size() > 0) {
            this.userMobileList = userMobileList;
        }
        return this;
    }

    public abstract void preToJsonSting();

    public Map<String, Object> getMap() {
        return this.map;
    }

    public BaseWebhookRequestBody addContent(String tag, String text) {
        this.map.put(tag, text);
        return this;
    }

    public BaseWebhookRequestBody addContent(String tag, Object obj) {
        this.map.put(tag, obj);
        return this;
    }

    public void setWebhookProductEnum(WebhookProductEnum webhookProductEnum) {
        this.webhookProductEnum = webhookProductEnum;
    }

    public WebhookProductEnum getWebhookProductEnum() {
        return this.webhookProductEnum;
    }

    public BaseWebhookRequestBody addGlobalInfo(GlobalInfo globalInfo) {
        this.globalInfo = globalInfo;
        return this;
    }
}

