/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.executor;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.param.ExecuteParam;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.response.ExecuteResponse;
import com.google.gson.Gson;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWebhookExecutor<RequestBody extends BaseWebhookRequestBody, Response> {
    private static final Logger log = LoggerFactory.getLogger(BaseWebhookExecutor.class);

    protected void beforeHandler(ExecuteParam executeParam) {
    }

    protected void afterHandler(ExecuteParam executeParam, ExecuteResponse<Response> executeResponse) {
    }

    protected abstract boolean checkResponseObjectHandler(ExecuteResponse<Response> var1);

    protected Response parseResponseHandler(ExecuteResponse<Response> executeResponse) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)genericSuperclass.getActualTypeArguments()[1];
        return (Response)new Gson().fromJson(executeResponse.originResponseContent, clazz);
    }

    protected void checkFailHandler(ExecuteParam executeParam, ExecuteResponse<Response> executeResponse) {
        log.error("{}\u53d1\u9001\u6d88\u606f\u5931\u8d25, requestContent = {}, originResponseContent = {}", new Object[]{this.webhookProductEnum().chineseName, executeParam.content, executeResponse.originResponseContent});
    }

    protected void checkSuccessHandler(ExecuteParam executeParam, ExecuteResponse<Response> executeResponse) {
        log.info("{}\u53d1\u9001\u6d88\u606f\u6210\u529f, requestContent = {}, originResponseContent = {}", new Object[]{this.webhookProductEnum().chineseName, executeParam.content, executeResponse.originResponseContent});
    }

    protected abstract WebhookProductEnum webhookProductEnum();

    protected void execute(String url, String content) {
        this.execute(ExecuteParam.newInstance(url, content));
    }

    protected void execute(ExecuteParam executeParam) {
        this.beforeHandler(executeParam);
        ExecuteResponse<Response> executeResponse = this.executeRequest(executeParam);
        executeResponse.parsedResponseObject = this.parseResponseHandler(executeResponse);
        executeResponse.checkResult = this.checkResponseObjectHandler(executeResponse);
        if (!executeResponse.checkResult) {
            this.checkFailHandler(executeParam, executeResponse);
        } else {
            this.checkSuccessHandler(executeParam, executeResponse);
        }
        this.afterHandler(executeParam, executeResponse);
    }

    private ExecuteResponse<Response> executeRequest(ExecuteParam executeParam) {
        ExecuteResponse executeResponse = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(executeParam.url);
            post.setHeader("Accept", "aplication/json");
            post.setHeader("Content-Type", "application/json;charset=UTF-8");
            StringEntity se = new StringEntity(executeParam.content, "UTF-8");
            se.setContentEncoding("UTF-8");
            se.setContentType("application/json");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String originResponseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            executeResponse = new ExecuteResponse(statusCode, originResponseContent);
        }
        catch (Exception e) {
            log.error("{}\u53d1\u9001\u6d88\u606f\u5931\u8d25, \u5f02\u5e38\u539f\u56e0\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return executeResponse;
    }

    public void execute(String url, RequestBody requestBody) {
        if (Objects.nonNull(requestBody)) {
            this.execute(url, ((BaseWebhookRequestBody)requestBody).toJsonSting());
        } else {
            log.warn("dingTalkRequestBody is NULL");
        }
    }

    protected Response getParsedResponse(ExecuteResponse<Response> executeResponse) {
        return (Response)executeResponse.parsedResponseObject;
    }
}

