/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.event;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.GlobalInfo;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.request.WebhookRequestBodyFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.springframework.context.ApplicationEvent;

public class WebhookEvent
extends ApplicationEvent {
    private String noticeUrl;
    private String basePackageName;
    private GlobalInfo globalInfo;
    private String title;
    private BaseWebhookRequestBody baseWebhookRequestBody;
    private WebhookProductEnum webhookProductEnum;
    private Consumer<BaseWebhookRequestBody> consumer;
    private Throwable throwable;
    private List<String> userIdList;
    private List<String> userMobileList;

    public WebhookEvent(Object source, Throwable throwable, WebhookProductEnum webhookProductEnum, String title, Consumer<BaseWebhookRequestBody> consumer) {
        super(source);
        this.title = title;
        this.consumer = consumer;
        this.throwable = throwable;
        if (Objects.nonNull((Object)webhookProductEnum)) {
            this.fillField(webhookProductEnum);
        }
    }

    public WebhookEvent(Object source, Throwable throwable, WebhookProductEnum webhookProductEnum, String title, List<String> userIdList, Consumer<BaseWebhookRequestBody> consumer) {
        super(source);
        this.title = title;
        this.consumer = consumer;
        this.throwable = throwable;
        if (userIdList != null && userIdList.size() > 0) {
            this.userIdList = userIdList;
        }
        if (Objects.nonNull((Object)webhookProductEnum)) {
            this.fillField(webhookProductEnum);
        }
    }

    public WebhookEvent(Object source, Throwable throwable, WebhookProductEnum webhookProductEnum, String title, Consumer<BaseWebhookRequestBody> consumer, List<String> userMobileList) {
        super(source);
        this.title = title;
        this.consumer = consumer;
        this.throwable = throwable;
        if (userMobileList != null && userMobileList.size() > 0) {
            this.userMobileList = userMobileList;
        }
        if (Objects.nonNull((Object)webhookProductEnum)) {
            this.fillField(webhookProductEnum);
        }
    }

    public WebhookEvent(Object source, Throwable throwable, WebhookProductEnum webhookProductEnum, String title, Consumer<BaseWebhookRequestBody> consumer, List<String> userIdList, List<String> userMobileList) {
        super(source);
        this.title = title;
        this.consumer = consumer;
        this.throwable = throwable;
        if (userIdList != null && userIdList.size() > 0) {
            this.userIdList = userIdList;
        }
        if (userMobileList != null && userMobileList.size() > 0) {
            this.userMobileList = userMobileList;
        }
        if (Objects.nonNull((Object)webhookProductEnum)) {
            this.fillField(webhookProductEnum);
        }
    }

    public WebhookEvent fillField(WebhookProductEnum webhookProductEnum) {
        this.webhookProductEnum = webhookProductEnum;
        this.baseWebhookRequestBody = WebhookRequestBodyFactory.newInstance(webhookProductEnum, this.title, this.userIdList, this.userMobileList);
        this.consumer.accept(this.baseWebhookRequestBody);
        this.globalInfo = new GlobalInfo(webhookProductEnum, this.throwable, null);
        this.baseWebhookRequestBody.addGlobalInfo(this.globalInfo);
        return this;
    }

    public boolean needFillField() {
        return Objects.isNull((Object)this.webhookProductEnum);
    }

    public WebhookProductEnum getWebhookProductEnum() {
        return this.webhookProductEnum;
    }

    public void setMachineInfoMap(LinkedHashMap<String, String> machineInfoMap) {
        this.globalInfo.setMachineInfoMap(machineInfoMap);
    }

    public void setGitProperties(Properties gitProperties) {
        this.globalInfo.setGitProperties(gitProperties);
    }

    public String getOccurTime() {
        return this.globalInfo.getOccurTime();
    }

    public BaseWebhookRequestBody getBaseWebhookRequestBody() {
        return this.baseWebhookRequestBody;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBasePackName(String basePackName) {
        this.globalInfo.setBasePackName(basePackName);
    }

    public String getNoticeUrl() {
        return this.noticeUrl;
    }

    public void setNoticeUrl(String noticeUrl) {
        this.noticeUrl = noticeUrl;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public void setBasePackageName(String basePackageName) {
        this.basePackageName = basePackageName;
    }
}

