/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TimeTool {
    private static final String date_pattern = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String default_pattern = "yyyy-MM-dd HH:mm:ss";
    private static final String local_date_time_pattern = "uuuu-MM-dd'T'HH:mm:ss.SSS";

    public static String convertDateStr(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = null;
        if (StringUtils.length((CharSequence)dateStr) == date_pattern.length()) {
            dateTimeFormatter = DateTimeFormatter.ofPattern(date_pattern, Locale.ENGLISH);
        } else if (StringUtils.length((CharSequence)dateStr) == local_date_time_pattern.length()) {
            dateTimeFormatter = DateTimeFormatter.ofPattern(local_date_time_pattern, Locale.ENGLISH);
        }
        if (Objects.isNull(dateTimeFormatter)) {
            return null;
        }
        LocalDateTime parseLocalDateTime = LocalDateTime.parse(dateStr, dateTimeFormatter);
        DateTimeFormatter defaultTimeFormatter = DateTimeFormatter.ofPattern(default_pattern);
        return defaultTimeFormatter.format(parseLocalDateTime);
    }

    public static LocalDateTime getBeijingTime() {
        return LocalDateTime.now(ZoneOffset.of("+8"));
    }

    public static LocalDateTime getMexicoTime() {
        return LocalDateTime.now(ZoneOffset.of("-6"));
    }

    public static LocalDateTime getGMTTime() {
        return LocalDateTime.now(ZoneOffset.of("+0"));
    }
}

