/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper OBJECT_MAPPER_INCLUDE_ALWAYS = new ObjectMapper();
    private static final ObjectMapper OBJECT_MAPPER_INCLUDE_NONEMPTY = new ObjectMapper();

    private JsonUtils() {
    }

    public static String toJson(Object object) {
        return JsonUtils.toJson(object, JsonInclude.Include.NON_EMPTY);
    }

    public static String toJson(Object object, JsonInclude.Include include) {
        ObjectMapper objectMapper;
        if (object == null) {
            return "";
        }
        if (include == null || include == JsonInclude.Include.NON_EMPTY) {
            objectMapper = OBJECT_MAPPER_INCLUDE_NONEMPTY;
        } else if (include == JsonInclude.Include.ALWAYS) {
            objectMapper = OBJECT_MAPPER_INCLUDE_ALWAYS;
        } else {
            objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(include);
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            LOGGER.error("JSON\u8f6c\u6362\u5f02\u5e38{}", object, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER_INCLUDE_ALWAYS.readValue(json, clazz);
        }
        catch (IOException e) {
            LOGGER.error("JSON\u8f6c\u6362\u5f02\u5e38{},{}", new Object[]{json, clazz, e});
            throw new RuntimeException(e);
        }
    }

    public static <T> T toTypeReference(String json, TypeReference<T> typeReference) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER_INCLUDE_ALWAYS.readValue(json, typeReference);
        }
        catch (IOException e) {
            LOGGER.error("JSON\u8f6c\u6362\u5f02\u5e38{},{}", new Object[]{json, typeReference, e});
            throw new RuntimeException(e);
        }
    }

    public static <T> T toJavaType(String json, JavaType javaType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER_INCLUDE_ALWAYS.readValue(json, javaType);
        }
        catch (IOException e) {
            LOGGER.error("JSON\u8f6c\u6362\u5f02\u5e38{},{}", new Object[]{json, javaType, e});
            throw new RuntimeException(e);
        }
    }

    static {
        OBJECT_MAPPER_INCLUDE_ALWAYS.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER_INCLUDE_NONEMPTY.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OBJECT_MAPPER_INCLUDE_NONEMPTY.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

