/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business;

import cn.woodwhales.common.business.DeduplicateResult;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DataTool {
    public static <S, T> Set<T> toSet(List<S> source, Function<? super S, ? extends T> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptySet();
        }
        return source.stream().map(mapper).collect(Collectors.toSet());
    }

    public static <K, S, T> Map<K, T> toMap(List<S> source, Function<? super S, ? extends K> keyMapper, Function<? super S, ? extends T> valueMapper) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <K, S, T> Map<K, T> toMap(Collection<S> source, Function<? super S, ? extends K> keyMapper, Function<? super S, ? extends T> valueMapper, BinaryOperator<T> mergeFunction) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.stream().collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction));
    }

    public static <K, S> Map<K, S> toMap(List<S> source, Function<? super S, ? extends K> keyMapper) {
        return DataTool.toMap(source, keyMapper, Function.identity());
    }

    public static <K, S> Map<K, S> toMap(List<S> source, Function<? super S, ? extends K> keyMapper, BinaryOperator<S> mergeFunction) {
        return DataTool.toMap(source, keyMapper, Function.identity(), mergeFunction);
    }

    public static <S, T, K> Map<K, T> toMapFromList(List<S> source, Function<? super S, ? extends T> mapper, Function<? super T, ? extends K> keyMapper) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return DataTool.toMap(source.stream().map(mapper).collect(Collectors.toList()), keyMapper);
    }

    public static <K, S> Map<K, S> toMapForSaveOld(List<S> source, Function<? super S, ? extends K> keyMapper) {
        return DataTool.toMap(source, keyMapper, Function.identity(), (o1, o2) -> o1);
    }

    public static <K, S, T> Map<K, T> toMapForSaveOld(List<S> source, Function<? super S, ? extends K> keyMapper, Function<? super S, ? extends T> valueMapper) {
        return DataTool.toMap(source, keyMapper, valueMapper, (o1, o2) -> o1);
    }

    public static <K, S> Map<K, S> toMapForSaveNew(Collection<S> source, Function<? super S, ? extends K> keyMapper) {
        return DataTool.toMap(source, keyMapper, Function.identity(), (o1, o2) -> o2);
    }

    public static <K, S, T> Map<K, T> toMapForSaveNew(List<S> source, Function<? super S, ? extends K> keyMapper, Function<? super S, ? extends T> valueMapper) {
        return DataTool.toMap(source, keyMapper, valueMapper, (o1, o2) -> o2);
    }

    public static <S, T> List<T> toList(List<S> source, Function<? super S, ? extends T> mapper) {
        return DataTool.toList(source, mapper, false);
    }

    public static <S, T> List<T> toList(S[] array, Function<? super S, ? extends T> mapper) {
        return DataTool.toList(Arrays.asList(array), mapper);
    }

    public static <S, T> List<T> toList(List<S> source, Function<? super S, ? extends T> mapper, boolean distinct) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        if (distinct) {
            return source.stream().map(mapper).distinct().collect(Collectors.toList());
        }
        return source.stream().map(mapper).collect(Collectors.toList());
    }

    private static <S, T, K, V> List<T> toListWithMap(List<S> source, Map<K, V> map, Function<S, K> keyFunction, BiFunction<S, V, T> mapContainKeyFunction, boolean discard, Function<S, T> function) {
        Preconditions.checkNotNull(keyFunction, (Object)"keyFunction\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Preconditions.checkNotNull(mapContainKeyFunction, (Object)"mapContainKeyFunction\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (!discard) {
            Preconditions.checkNotNull(function, (Object)"list\u5143\u7d20\u4e0d\u5b58\u5728map\u96c6\u5408\u4e2d\u7684\u5904\u7406\u63a5\u53e3function\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        if (MapUtils.isEmpty(map)) {
            map = Collections.emptyMap();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (S s : source) {
            K key = keyFunction.apply(s);
            if (map.containsKey(key)) {
                V v = map.get(key);
                T t = mapContainKeyFunction.apply(s, v);
                result.add(t);
                continue;
            }
            if (discard) continue;
            T t = function.apply(s);
            result.add(t);
        }
        return result;
    }

    public static <S, T, K, V> List<T> toListWithMap(List<S> source, Map<K, V> map, Function<S, K> keyFunction, BiFunction<S, V, T> mapContainKeyFunction) {
        return DataTool.toListWithMap(source, map, keyFunction, mapContainKeyFunction, true, null);
    }

    public static <S, T, K, V> List<T> toListWithMap(List<S> source, Map<K, V> map, Function<S, K> keyFunction, BiFunction<S, V, T> mapContainKeyFunction, Function<S, T> function) {
        Preconditions.checkNotNull(function, (Object)"function\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        return DataTool.toListWithMap(source, map, keyFunction, mapContainKeyFunction, false, function);
    }

    public static <S, T> List<T> toList(List<S> source, Predicate<S> filter, Function<? super S, ? extends T> mapper, boolean distinct) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        Stream stream = source.stream().filter(filter::test).map(mapper);
        if (distinct) {
            stream = stream.distinct();
        }
        return stream.collect(Collectors.toList());
    }

    public static <S, T> List<T> toList(S[] source, Predicate<S> filter, Function<? super S, ? extends T> mapper, boolean distinct) {
        if (Objects.isNull(source)) {
            return Collections.emptyList();
        }
        Stream stream = Stream.of(source).filter(filter::test).map(mapper);
        if (distinct) {
            stream = stream.distinct();
        }
        return stream.collect(Collectors.toList());
    }

    public static <S, T> List<T> toList(List<S> source, Predicate<S> filter, Function<? super S, ? extends T> mapper) {
        return DataTool.toList(source, filter, mapper, false);
    }

    public static <K, T, R> List<R> toListByMap(Map<K, T> map, BiFunction<K, T, R> function) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        return map.entrySet().stream().map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <K, T, R> List<R> toListByMap(Map<K, T> map, BiPredicate<K, T> filterMapMapper, BiFunction<K, T, R> function) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        return map.entrySet().stream().filter(entry -> filterMapMapper.test(entry.getKey(), entry.getValue())).map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <K, S> Map<K, List<S>> groupingBy(List<S> source, Function<? super S, ? extends K> classifier) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.stream().collect(Collectors.groupingBy(classifier));
    }

    public static <K, S> Map<K, List<S>> groupingBy(List<S> source, Predicate<S> filter, Function<? super S, ? extends K> classifier) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.stream().filter(filter::test).collect(Collectors.groupingBy(classifier));
    }

    public static <T> List<T> sort(List<T> source, Comparator<T> comparator) {
        return DataTool.sort(source, comparator, true);
    }

    public static <T> List<T> sort(List<T> source, Comparator<T> comparator, boolean reverse) {
        if (CollectionUtils.isEmpty(source)) {
            return source;
        }
        Stream stream = source.stream();
        Stream sorted = reverse ? stream.sorted(comparator.reversed()) : stream.sorted(comparator);
        return sorted.collect(Collectors.toList());
    }

    public static <K, T> DeduplicateResult<K, T> deduplicate(List<T> source, Function<T, Boolean> isValidFunction, Function<T, K> getDeduplicatedKeyFunction) {
        return DataTool.deduplicate(source, isValidFunction, getDeduplicatedKeyFunction, false);
    }

    public static <K, T> DeduplicateResult<K, T> deduplicate(List<T> source, Function<T, K> getDeduplicatedKeyFunction) {
        return DataTool.deduplicate(source, null, getDeduplicatedKeyFunction, false);
    }

    public static <K, T> DeduplicateResult<K, T> deduplicate(List<T> source, Function<T, K> getDeduplicatedKeyFunction, boolean remainFirst) {
        return DataTool.deduplicate(source, null, getDeduplicatedKeyFunction, remainFirst);
    }

    public static <K, T> DeduplicateResult<K, T> deduplicate(List<T> source, Function<T, Boolean> isValidFunction, Function<T, K> getDeduplicatedKeyFunction, boolean remainFirst) {
        if (CollectionUtils.isEmpty(source)) {
            return new DeduplicateResult(source, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        LinkedHashMap<K, T> container = new LinkedHashMap<K, T>();
        LinkedList<T> invalidList = new LinkedList<T>();
        LinkedList<T> repetitiveList = new LinkedList<T>();
        for (T data : source) {
            if (Objects.nonNull(isValidFunction) && !Objects.equals(true, isValidFunction.apply(data))) {
                invalidList.add(data);
                continue;
            }
            K deduplicatedKey = getDeduplicatedKeyFunction.apply(data);
            if (container.containsKey(deduplicatedKey)) {
                T putData = remainFirst ? data : container.put(deduplicatedKey, data);
                if (!Objects.nonNull(putData)) continue;
                repetitiveList.add(putData);
                continue;
            }
            container.put(deduplicatedKey, data);
        }
        ArrayList deduplicatedList = new ArrayList(container.values());
        ArrayList deduplicatedKeyList = new ArrayList(container.keySet());
        return new DeduplicateResult(source, invalidList, deduplicatedList, deduplicatedKeyList, repetitiveList);
    }

    public static <K, T extends Enum<T>> Map<K, T> enumMap(Class<T> sourceEnumClass, Function<T, K> keyMapper) {
        EnumSet<T> enumSet = EnumSet.allOf(sourceEnumClass);
        return enumSet.stream().collect(Collectors.toMap(keyMapper, Function.identity()));
    }

    public static <T extends Enum<T>> Map<String, T> enumMap(Class<T> sourceEnumClass) {
        EnumSet<T> enumSet = EnumSet.allOf(sourceEnumClass);
        return enumSet.stream().collect(Collectors.toMap(Enum::name, Function.identity()));
    }

    public static <T extends Enum<T>, R> List<R> enumList(Class<T> sourceEnumClass, Function<T, R> function) {
        EnumSet<T> enumSet = EnumSet.allOf(sourceEnumClass);
        return enumSet.stream().map(function).collect(Collectors.toList());
    }

    public static <K, T extends Enum<T>> boolean enumContainsKey(K key, Class<T> sourceEnumClass, Function<T, K> keyMapper) {
        if (Objects.isNull(key)) {
            return false;
        }
        Map<K, T> map = DataTool.enumMap(sourceEnumClass, keyMapper);
        return map.containsKey(key);
    }

    public static <K, T extends Enum<T>> T enumGetValue(K key, Class<T> sourceEnumClass, Function<T, K> keyMapper) {
        if (Objects.isNull(key)) {
            return null;
        }
        Map<K, T> map = DataTool.enumMap(sourceEnumClass, keyMapper);
        return (T)((Enum)map.get(key));
    }

    public static <T> List<T> filter(List<T> source, Predicate<? super T> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        return source.stream().filter(filter).collect(Collectors.toList());
    }

    public static <T> List<T> filter(T[] source, Predicate<? super T> filter) {
        if (Objects.isNull(source)) {
            return Collections.emptyList();
        }
        return Stream.of(source).filter(filter).collect(Collectors.toList());
    }

    public static <M, K, T> T getDataFromList(M searchData, Function<M, K> searchFunction, List<T> sourceList, Function<T, K> keyFunction) {
        Preconditions.checkNotNull(searchFunction, (Object)"function\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(sourceList)) {
            return null;
        }
        return DataTool.toMapForSaveNew(sourceList, keyFunction).get(searchFunction.apply(searchData));
    }

    public static <K, T> Map<K, T> handleMap(Map<K, T> map, BiConsumer<K, T> handlerMapper) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        for (Map.Entry<K, T> entry : map.entrySet()) {
            K key = entry.getKey();
            T value = entry.getValue();
            handlerMapper.accept(key, value);
        }
        return map;
    }

    public static <T> List<T> removeNull(List<? extends T> oldList) {
        oldList.removeAll(Collections.singleton(null));
        return oldList;
    }

    public static <K, V, R> List<R> mapValueToList(Map<K, V> map, Function<V, R> function) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        return map.values().stream().map(function).collect(Collectors.toList());
    }

    public static <K, V, R> List<R> mapToList(Map<K, V> map, BiFunction<K, V, R> function) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        return map.entrySet().stream().map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <K, V, R> List<R> mapToList(Map<K, V> map, BiPredicate<K, V> predicate, BiFunction<K, V, R> function) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        return map.entrySet().stream().filter(entry -> predicate.test(entry.getKey(), entry.getValue())).map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <S1, S2, K, R> List<R> getListFromBaseList(List<S1> sourceList, Function<S1, K> sourceDataKeyFunction, List<S2> baseList, Function<S2, K> baseDataKeyFunction, BiFunction<S1, S2, R> function) {
        ArrayList<R> resultList = new ArrayList<R>();
        Map<K, S2> baseDataMap = DataTool.toMap(baseList, baseDataKeyFunction);
        for (S1 sourceData : sourceList) {
            K sourceDataKey = sourceDataKeyFunction.apply(sourceData);
            if (!baseDataMap.containsKey(sourceDataKey)) continue;
            S2 baseData = baseDataMap.get(sourceDataKey);
            R result = function.apply(sourceData, baseData);
            resultList.add(result);
        }
        return resultList;
    }

    public static <S1, S2, K, R> List<R> getListFromBaseList(List<S1> sourceList, Function<S1, R> resultFunction, Function<R, K> resultDataKeyFunction, List<S2> baseList, Function<S2, K> baseDataKeyFunction, BiConsumer<R, List<S2>> consumer) {
        List<R> resultList = DataTool.toList(sourceList, resultFunction);
        Map<K, List<S2>> listMap = DataTool.groupingBy(baseList, baseDataKeyFunction);
        for (R result : resultList) {
            List<S2> baseDataList;
            K resultKey = resultDataKeyFunction.apply(result);
            if (!listMap.containsKey(resultKey) || !CollectionUtils.isNotEmpty(baseDataList = listMap.get(resultKey))) continue;
            consumer.accept(result, baseDataList);
        }
        return resultList;
    }

    public static <T> T getFirstItem(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T getLastItem(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }
}

