/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.model.request;

import cn.woodwhales.common.util.JsonUtils;
import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.WebhookGlobalInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseWebhookRequestBody {
    @JsonIgnore
    protected WebhookProductEnum webhookProductEnum;
    @JsonIgnore
    protected WebhookGlobalInfo webhookGlobalInfo;
    @JsonIgnore
    protected List<String> userIdList;
    @JsonIgnore
    protected List<String> userMobileList;
    @JsonIgnore
    protected Map<String, String> map = new LinkedHashMap<String, String>();

    public String toJsonSting() {
        List<Pair<String, String>> allInfoPair = this.webhookGlobalInfo.getAllInfoPair();
        allInfoPair.stream().forEach(pair -> this.map.put((String)pair.getLeft(), (String)pair.getRight()));
        this.preToJsonSting();
        return JsonUtils.toJson(this);
    }

    protected BaseWebhookRequestBody addUserIdList(List<String> userIdList) {
        if (userIdList != null && userIdList.size() > 0) {
            this.userIdList = userIdList;
        }
        return this;
    }

    protected BaseWebhookRequestBody addUserMobileList(List<String> userMobileList) {
        if (userMobileList != null && userMobileList.size() > 0) {
            this.userMobileList = userMobileList;
        }
        return this;
    }

    public abstract void preToJsonSting();

    public Map<String, String> getMap() {
        return this.map;
    }

    public BaseWebhookRequestBody addContent(String tag, String text) {
        this.map.put(tag, text);
        return this;
    }

    public void setWebhookProductEnum(WebhookProductEnum webhookProductEnum) {
        this.webhookProductEnum = webhookProductEnum;
    }

    public WebhookProductEnum getWebhookProductEnum() {
        return this.webhookProductEnum;
    }

    public BaseWebhookRequestBody addGlobalInfo(WebhookGlobalInfo webhookGlobalInfo) {
        this.webhookGlobalInfo = webhookGlobalInfo;
        return this;
    }
}

