/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.model;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WebhookGlobalInfo {
    public Throwable throwable;
    public LinkedHashMap<String, String> machineInfoMap;
    public Properties gitProperties;
    private String occurTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
    private String basePackName;
    private int LIMIT = 6666;
    private WebhookProductEnum webhookProductEnum;
    private String defaultErrorDesc = "\u5f02\u5e38\u6808\u4fe1\u606f\u592a\u957f\uff0c\u4e0d\u6253\u5370\u5168\u6808\u65e5\u5fd7";

    public WebhookGlobalInfo(WebhookProductEnum webhookProductEnum, Throwable throwable, String basePackName, LinkedHashMap<String, String> machineInfoMap, Properties gitProperties) {
        this.webhookProductEnum = webhookProductEnum;
        this.throwable = throwable;
        this.basePackName = basePackName;
        this.machineInfoMap = machineInfoMap;
        this.gitProperties = gitProperties;
    }

    public WebhookGlobalInfo(WebhookProductEnum webhookProductEnum, Throwable throwable, String basePackName) {
        this.webhookProductEnum = webhookProductEnum;
        this.throwable = throwable;
        this.basePackName = basePackName;
    }

    public void setMachineInfoMap(LinkedHashMap<String, String> machineInfoMap) {
        this.machineInfoMap = machineInfoMap;
    }

    public void setGitProperties(Properties gitProperties) {
        this.gitProperties = gitProperties;
    }

    public void setBasePackName(String basePackName) {
        this.basePackName = basePackName;
    }

    public List<Pair<String, String>> getAllInfoPair() {
        ArrayList<Pair<String, String>> allInfoPair = new ArrayList<Pair<String, String>>();
        this.generateOccurTime(allInfoPair);
        this.generateGitProperties(allInfoPair);
        this.generateMachineInfoMap(allInfoPair);
        this.generateThrowable(allInfoPair);
        return allInfoPair;
    }

    public String getOccurTime() {
        return this.occurTime;
    }

    private void generateOccurTime(List<Pair<String, String>> allInfoPair) {
        allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u53d1\u751f\u65f6\u95f4\uff1a", (Object)this.occurTime));
    }

    private void generateGitProperties(List<Pair<String, String>> allInfoPair) {
        if (Objects.nonNull(this.gitProperties)) {
            allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u90e8\u7f72\u5206\u652f\uff1a", (Object)this.gitProperties.getProperty("git.branch")));
        }
    }

    private void generateMachineInfoMap(List<Pair<String, String>> allInfoPair) {
        if (Objects.nonNull(this.machineInfoMap) && !this.machineInfoMap.isEmpty()) {
            this.machineInfoMap.entrySet().stream().forEach(entry -> allInfoPair.add(Pair.of(entry.getKey(), entry.getValue())));
        }
    }

    private void generateThrowable(List<Pair<String, String>> allInfoPair) {
        if (Objects.nonNull(this.throwable)) {
            allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u5f02\u5e38\u7c7b\u540d\uff1a", (Object)this.throwable.getClass().getName()));
            String errorMessage = this.throwable.getMessage();
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u5f02\u5e38\u539f\u56e0\uff1a", (Object)errorMessage));
            } else if (this.throwable instanceof NullPointerException) {
                allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u5f02\u5e38\u539f\u56e0\uff1a", (Object)"\u7a7a\u6307\u9488\u5f02\u5e38"));
            } else {
                allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u5f02\u5e38\u539f\u56e0\uff1a", (Object)"\u8be5\u5f02\u5e38\u7c7b\u65e0errorMessage"));
            }
            StackTraceElement[] stackTrace = this.throwable.getStackTrace();
            if (Objects.nonNull(stackTrace)) {
                String stackTraceAsString;
                int length;
                List systemStackInfoList = Stream.of(stackTrace).filter(stackTraceElement -> StringUtils.isNotBlank((CharSequence)this.basePackName) && StringUtils.containsIgnoreCase((CharSequence)stackTraceElement.getClassName(), (CharSequence)this.basePackName)).filter(stackTraceElement -> !StringUtils.containsIgnoreCase((CharSequence)stackTraceElement.getClassName(), (CharSequence)"$$")).map(stackTraceElement -> String.format("%s#%s(%s:%d)", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber())).collect(Collectors.toList());
                if (Objects.nonNull(systemStackInfoList) && !systemStackInfoList.isEmpty() && StringUtils.isNotBlank((CharSequence)this.basePackName)) {
                    allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u672c\u7cfb\u7edf ", (Object)(this.basePackName + " \u5305\u4e0b\u5f02\u5e38\u6808\u4fe1\u606f\uff1a")));
                    systemStackInfoList.stream().forEach(systemStackInfo -> allInfoPair.add(Pair.of((Object)"\u6808\u4fe1\u606f\uff1a", (Object)systemStackInfo)));
                }
                if (this.webhookProductEnum.limitContentLength > (length = StringUtils.length((CharSequence)(stackTraceAsString = Throwables.getStackTraceAsString((Throwable)this.throwable))))) {
                    allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u5168\u6808\u5f02\u5e38\u4fe1\u606f\uff1a", (Object)stackTraceAsString));
                } else {
                    allInfoPair.add((Pair<String, String>)Pair.of((Object)"\u5168\u6808\u5f02\u5e38\u4fe1\u606f\uff1a", (Object)this.defaultErrorDesc));
                }
            }
        }
    }
}

