/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.executor;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.executor.BaseWebhookExecutor;
import cn.woodwhales.common.webhook.executor.DingTalkWebhookExecutor;
import cn.woodwhales.common.webhook.executor.FeiShuWebhookExecutor;
import cn.woodwhales.common.webhook.executor.WeComWebhookExecutor;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.request.WebhookRequestBodyFactory;
import java.util.function.Consumer;

public class WebhookExecutorFactory {
    public static <RequestBody extends BaseWebhookRequestBody> BaseWebhookExecutor newInstance(WebhookProductEnum webhookProductEnum) {
        BaseWebhookExecutor baseWebhookExecutor = null;
        switch (webhookProductEnum) {
            case WE_COM: {
                baseWebhookExecutor = WeComWebhookExecutor.newInstance();
                break;
            }
            case DING_TALK: {
                baseWebhookExecutor = DingTalkWebhookExecutor.newInstance();
                break;
            }
            case FEI_SHU: {
                baseWebhookExecutor = FeiShuWebhookExecutor.newInstance();
            }
        }
        return baseWebhookExecutor;
    }

    public static void execute(String url, BaseWebhookRequestBody requestBody) {
        WebhookExecutorFactory.newInstance(requestBody.getWebhookProductEnum()).execute(url, requestBody);
    }

    public static void execute(WebhookProductEnum webhookProductEnum, String url, String title, Consumer<BaseWebhookRequestBody> consumer) {
        BaseWebhookRequestBody requestBody = WebhookRequestBodyFactory.newInstance(webhookProductEnum, title);
        consumer.accept(requestBody);
        WebhookExecutorFactory.newInstance(requestBody.getWebhookProductEnum()).execute(url, requestBody);
    }
}

