/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.executor;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.model.param.WebhookExecuteParam;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.response.WebhookExecuteResponse;
import com.google.gson.Gson;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWebhookExecutor<RequestBody extends BaseWebhookRequestBody, Response> {
    private static final Logger log = LoggerFactory.getLogger(BaseWebhookExecutor.class);

    protected void beforeHandler(WebhookExecuteParam webhookExecuteParam) {
    }

    protected void afterHandler(WebhookExecuteParam webhookExecuteParam, WebhookExecuteResponse<Response> executeResponse) {
    }

    protected abstract boolean checkResponseObjectHandler(WebhookExecuteResponse<Response> var1);

    protected Response parseResponseHandler(WebhookExecuteResponse<Response> executeResponse) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)genericSuperclass.getActualTypeArguments()[1];
        return (Response)new Gson().fromJson(executeResponse.originResponseContent, clazz);
    }

    protected void checkFailHandler(WebhookExecuteParam webhookExecuteParam, WebhookExecuteResponse<Response> executeResponse) {
        log.error("{}\u53d1\u9001\u6d88\u606f\u5931\u8d25, requestContent = {}, originResponseContent = {}", new Object[]{this.webhookProductEnum().chineseName, webhookExecuteParam.content, executeResponse.originResponseContent});
    }

    protected void checkSuccessHandler(WebhookExecuteParam webhookExecuteParam, WebhookExecuteResponse<Response> executeResponse) {
        log.info("{}\u53d1\u9001\u6d88\u606f\u6210\u529f, requestContent = {}, originResponseContent = {}", new Object[]{this.webhookProductEnum().chineseName, webhookExecuteParam.content, executeResponse.originResponseContent});
    }

    protected abstract WebhookProductEnum webhookProductEnum();

    protected void execute(String url, String content) {
        this.execute(WebhookExecuteParam.newInstance(url, content));
    }

    protected void execute(WebhookExecuteParam webhookExecuteParam) {
        this.beforeHandler(webhookExecuteParam);
        WebhookExecuteResponse<Response> executeResponse = this.executeRequest(webhookExecuteParam);
        executeResponse.parsedResponseObject = this.parseResponseHandler(executeResponse);
        executeResponse.checkResult = this.checkResponseObjectHandler(executeResponse);
        if (!executeResponse.checkResult) {
            this.checkFailHandler(webhookExecuteParam, executeResponse);
        } else {
            this.checkSuccessHandler(webhookExecuteParam, executeResponse);
        }
        this.afterHandler(webhookExecuteParam, executeResponse);
    }

    private WebhookExecuteResponse<Response> executeRequest(WebhookExecuteParam webhookExecuteParam) {
        WebhookExecuteResponse executeResponse = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(webhookExecuteParam.url);
            post.setHeader("Accept", "aplication/json");
            post.setHeader("Content-Type", "application/json;charset=UTF-8");
            StringEntity se = new StringEntity(webhookExecuteParam.content, "UTF-8");
            se.setContentEncoding("UTF-8");
            se.setContentType("application/json");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String originResponseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            executeResponse = new WebhookExecuteResponse(statusCode, originResponseContent);
        }
        catch (Exception e) {
            log.error("{}\u53d1\u9001\u6d88\u606f\u5931\u8d25, \u5f02\u5e38\u539f\u56e0\uff1a", (Object)e.getMessage(), (Object)e);
        }
        return executeResponse;
    }

    public void execute(String url, RequestBody requestBody) {
        if (Objects.nonNull(requestBody)) {
            this.execute(url, ((BaseWebhookRequestBody)requestBody).toJsonSting());
        } else {
            log.warn("dingTalkRequestBody is NULL");
        }
    }

    protected Response getParsedResponse(WebhookExecuteResponse<Response> executeResponse) {
        return (Response)executeResponse.parsedResponseObject;
    }
}

