/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.webhook.event;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.event.WebhookEvent;
import cn.woodwhales.common.webhook.executor.WebhookExecutorFactory;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.plugin.WebhookExtraInfo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookEventHandler {
    private static final Logger log = LoggerFactory.getLogger(WebhookEventHandler.class);

    public static void handleCustomEvent(WebhookEvent webhookEvent, String noticeUrl, String basePackageName, WebhookExtraInfo webhookExtraInfo) {
        if (webhookEvent.needFillField()) {
            WebhookProductEnum webhookProductEnum = WebhookProductEnum.getWebhookProductEnumByNoticeUrl(noticeUrl);
            webhookEvent.fillField(webhookProductEnum);
        }
        log.info("\u76d1\u542c\u5230\u5f02\u5e38\u62a5\u8b66\u4e8b\u4ef6\uff0c\u6d88\u606f\u4e3a\uff1a{}, \u53d1\u5e03\u65f6\u95f4\uff1a{}", (Object)webhookEvent.getOccurTime(), (Object)webhookEvent.getTitle());
        webhookEvent.setBasePackName(basePackageName);
        if (Objects.nonNull(webhookExtraInfo)) {
            webhookEvent.setGitProperties(webhookExtraInfo.getGitProperties());
            webhookEvent.setMachineInfoMap(webhookExtraInfo.getMachineInfoMap());
        }
        BaseWebhookRequestBody webhookRequest = webhookEvent.getBaseWebhookRequestBody();
        WebhookExecutorFactory.execute(noticeUrl, webhookRequest);
    }
}

