/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util.excel;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.util.excel.ExcelDateField;
import cn.woodwhales.common.util.excel.ExcelField;
import cn.woodwhales.common.util.excel.ExcelFieldType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelTool {
    public static <T> List<T> parseData(String filePath, BiFunction<Integer, Row, T> function) {
        return ExcelTool.parseData(filePath, 0, 1, function);
    }

    public static <T> List<T> parseData(InputStream inputStream, BiFunction<Integer, Row, T> function) {
        return ExcelTool.parseData(ExcelTool.buildWorkbook(inputStream), 0, 1, function, null);
    }

    public static <T> List<T> parseData(InputStream inputStream, Class<T> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Map<String, ExcelFieldConfig> excelFieldConfigMap = DataTool.toMapForSaveNew(DataTool.toList(declaredFields, ExcelFieldConfig::new), ExcelFieldConfig::getExcelFieldName);
        AtomicReference excelFieldConfigMap2 = new AtomicReference();
        return ExcelTool.parseData(ExcelTool.buildWorkbook(inputStream), 0, 1, (index, row) -> {
            int physicalNumberOfCells = row.getPhysicalNumberOfCells();
            Object target = null;
            Cell cell = null;
            try {
                target = clazz.newInstance();
                for (int cellIndex = 0; cellIndex < physicalNumberOfCells; ++cellIndex) {
                    cell = row.getCell(cellIndex);
                    ExcelFieldConfig excelFieldConfig = (ExcelFieldConfig)((Map)excelFieldConfigMap2.get()).get(cellIndex);
                    ExcelTool.fillFieldValue(target, row, cell, excelFieldConfig);
                }
            }
            catch (Exception e) {
                System.out.println("cell value = " + cell);
                e.printStackTrace();
            }
            return target;
        }, (cellIndex, row) -> {
            Cell cell = row.getCell(cellIndex.intValue());
            if (Objects.nonNull(cell)) {
                String cellName = cell.getStringCellValue();
                if (excelFieldConfigMap.containsKey(cellName)) {
                    ((ExcelFieldConfig)excelFieldConfigMap.get((Object)cellName)).cellIndex = cellIndex;
                }
                if (cellIndex.equals(row.getPhysicalNumberOfCells() - 1)) {
                    excelFieldConfigMap2.set(DataTool.toMapForSaveNew(excelFieldConfigMap.values(), ExcelFieldConfig::getCellIndex));
                }
            }
        });
    }

    private static <T> void fillFieldValue(T target, Row row, Cell cell, ExcelFieldConfig excelFieldConfig) throws IllegalAccessException {
        if (Objects.isNull(cell) || Objects.isNull(excelFieldConfig)) {
            return;
        }
        excelFieldConfig.fillField(target, row, cell);
    }

    public static <T> List<T> parseData(String filePath, int sheetIndex, int skipLineNumbers, BiFunction<Integer, Row, T> function) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException(filePath + " \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Workbook workbook = ExcelTool.buildWorkbook(file);
        return ExcelTool.parseData(workbook, sheetIndex, skipLineNumbers, function, null);
    }

    private static <T> List<T> parseData(Workbook workbook, int sheetIndex, int skipLineNumbers, BiFunction<Integer, Row, T> function, BiConsumer<Integer, Row> skipConsumer) {
        Sheet sheet;
        Objects.requireNonNull(function, "function\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (Objects.isNull(sheetIndex)) {
            sheetIndex = 0;
        }
        if (Objects.isNull(skipLineNumbers)) {
            skipLineNumbers = 0;
        }
        if (Objects.isNull(sheet = workbook.getSheetAt(sheetIndex))) {
            throw new RuntimeException("sheetIndex = " + sheetIndex + " \u4e0d\u5b58\u5728");
        }
        ArrayList<T> dataList = new ArrayList<T>(sheet.getLastRowNum());
        int rowIndex = 0;
        while (rowIndex <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(rowIndex);
            if (Objects.isNull(row)) {
                ++rowIndex;
                continue;
            }
            if (row.getRowNum() < skipLineNumbers) {
                if (Objects.nonNull(skipConsumer)) {
                    int physicalNumberOfCells = row.getPhysicalNumberOfCells();
                    for (int cellIndex = 0; cellIndex < physicalNumberOfCells; ++cellIndex) {
                        skipConsumer.accept(cellIndex, row);
                    }
                }
                ++rowIndex;
                continue;
            }
            Integer tmpRowIndex = rowIndex;
            T data = function.apply(tmpRowIndex, row);
            dataList.add(data);
            ++rowIndex;
        }
        return dataList;
    }

    public static String getStringValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return "";
        }
        if (!Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            cell.setCellType(CellType.STRING);
        }
        return cell.getStringCellValue();
    }

    public static Byte getByteValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return numericCellValue.byteValue();
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Byte.parseByte(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static Long getLongValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return Long.parseLong(ExcelTool.formatNumeric(numericCellValue));
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Long.parseLong(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static Double getDoubleValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return Double.parseDouble(ExcelTool.formatNumeric(numericCellValue));
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Double.parseDouble(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    private static String formatNumeric(Double numericCellValue) {
        DecimalFormat decimalFormat = new DecimalFormat("0");
        if (Objects.isNull(numericCellValue)) {
            return null;
        }
        return decimalFormat.format(numericCellValue);
    }

    public static Integer getIntegerValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (Objects.equals(CellType.NUMERIC, cell.getCellTypeEnum())) {
            Double numericCellValue = cell.getNumericCellValue();
            if (Objects.isNull(numericCellValue)) {
                return null;
            }
            return Integer.parseInt(ExcelTool.formatNumeric(numericCellValue));
        }
        if (Objects.equals(CellType.STRING, cell.getCellTypeEnum())) {
            String stringCellValue = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)stringCellValue)) {
                return null;
            }
            return Integer.parseInt(stringCellValue);
        }
        throw new RuntimeException("cellIndex=[" + cellIndex + "]\u4e0d\u662f\u6570\u503c\u5355\u5143\u683c");
    }

    public static Date getDateValue(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (Objects.isNull(cell)) {
            return null;
        }
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            Date date = cell.getDateCellValue();
            return date;
        }
        return null;
    }

    public static String getFormatDateValue(Row row, int cellIndex) {
        return ExcelTool.getFormatDateValue(row, cellIndex, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatDateValue(Row row, int cellIndex, String pattern) {
        Date dateValue = ExcelTool.getDateValue(row, cellIndex);
        if (Objects.isNull(dateValue)) {
            return "";
        }
        return DateFormatUtils.format((Date)dateValue, (String)pattern);
    }

    private static Workbook buildWorkbook(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (IOException | InvalidFormatException e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private static Workbook buildWorkbook(File file) {
        Workbook workbook = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            workbook = ExcelTool.buildWorkbook(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private ExcelTool() {
    }

    private static class ExcelFieldConfig {
        public ExcelFieldType excelFieldType;
        public Field field;
        public Integer cellIndex;
        public Class<?> clazz;
        public String excelFieldName;
        public String pattern;

        private ExcelFieldConfig() {
        }

        ExcelFieldConfig(Field field) {
            ExcelDateField excelDateField;
            this.field = field;
            ExcelField excelField = field.getAnnotation(ExcelField.class);
            if (Objects.nonNull(excelField)) {
                this.excelFieldType = ExcelFieldType.NORMAL;
                this.clazz = excelField.type();
                this.excelFieldName = excelField.value();
            }
            if (Objects.nonNull(excelDateField = field.getAnnotation(ExcelDateField.class))) {
                this.excelFieldType = ExcelFieldType.DATE_STR;
                this.clazz = String.class;
                this.excelFieldName = excelDateField.value();
                this.pattern = excelDateField.pattern();
            }
            if (Objects.isNull(excelField) && Objects.isNull(excelDateField)) {
                this.excelFieldType = ExcelFieldType.DEFAULT;
                this.clazz = field.getType();
                this.excelFieldName = field.getName();
            }
        }

        public String getExcelFieldName() {
            return this.excelFieldName;
        }

        public Integer getCellIndex() {
            return this.cellIndex;
        }

        public void fillField(Object target, Row row, Cell cell) throws IllegalAccessException {
            boolean accessible = this.field.isAccessible();
            this.field.setAccessible(true);
            String typeName = this.clazz.getName();
            if (String.class.getName().equals(typeName)) {
                if (ExcelFieldType.DATE_STR.equals((Object)this.excelFieldType)) {
                    this.field.set(target, DateFormatUtils.format((Date)ExcelTool.getDateValue(row, this.cellIndex), (String)this.pattern));
                } else {
                    this.field.set(target, cell.getStringCellValue());
                }
            } else if (Integer.class.getName().equals(typeName)) {
                this.field.set(target, ExcelTool.getIntegerValue(row, this.cellIndex));
            } else if (Double.class.getName().equals(typeName)) {
                this.field.set(target, ExcelTool.getDoubleValue(row, this.cellIndex));
            } else if (Date.class.getName().equals(typeName)) {
                this.field.set(target, ExcelTool.getDateValue(row, this.cellIndex));
            } else if (Byte.class.getName().equals(typeName)) {
                this.field.set(target, ExcelTool.getByteValue(row, this.cellIndex));
            }
            this.field.setAccessible(accessible);
        }
    }
}

