/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.util.datasource;

import cn.woodwhales.common.util.datasource.DataColumn;
import cn.woodwhales.common.util.datasource.DataTable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTool {
    private static final Logger log = LoggerFactory.getLogger(DataSourceTool.class);
    private String driverClass;
    private String url;
    private String username;
    private String password;
    private Connection connection;
    private Map<Class<?>, TargetInfo> targetInfoCache = new HashMap(16);
    private Map<Class<? extends Annotation>, Function<? extends Annotation, String>> annotationCache = new HashMap<Class<? extends Annotation>, Function<? extends Annotation, String>>(16);

    public static DataSourceTool newMysql(String url, String username, String password) {
        return new DataSourceTool("com.mysql.jdbc.Driver", url, username, password);
    }

    public static DataSourceTool newMysql8(String url, String username, String password) {
        return new DataSourceTool("com.mysql.cj.jdbc.Driver", url, username, password);
    }

    public static DataSourceTool newOracle(String url, String username, String password) {
        return new DataSourceTool("oracle.jdbc.OracleDriver", url, username, password);
    }

    public <A extends Annotation> DataSourceTool(String driverClass, String url, String username, String password) {
        this.driverClass = driverClass;
        this.url = url;
        this.username = username;
        this.password = password;
        try {
            Connection connection;
            Class.forName(this.driverClass);
            this.connection = connection = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                SQLException sqlException = (SQLException)cause;
                String sqlState = sqlException.getSQLState();
                if ("28000".equals(sqlState)) {
                    System.out.println("\u6570\u636e\u5e93\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!!!");
                }
            } else {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }

    public <T, A extends Annotation> List<T> queryList(String sql, Class<T> clazz, Class<A> annotationClass, Function<A, String> function) throws Exception {
        return this.queryList(sql, this.getTarget(clazz, annotationClass, function));
    }

    private <T, A extends Annotation> TargetInfo<T, A> cacheTarget(Class<T> clazz, Class<A> annotationClass, Function<A, String> function) {
        if (!this.targetInfoCache.containsKey(clazz)) {
            this.targetInfoCache.put(clazz, new TargetInfo<T, A>(clazz, annotationClass, function));
        }
        return this.targetInfoCache.get(clazz);
    }

    public <T, A extends Annotation> T queryOne(String sql, Class<T> clazz, Class<A> annotationClass, Function<A, String> function) throws Exception {
        return this.queryOne(sql, this.getTarget(clazz, annotationClass, function));
    }

    private <T, A extends Annotation> Function<ResultSet, T> getTarget(Class<T> clazz, Class<A> annotationClass, Function<A, String> function) {
        this.cacheTarget(clazz, annotationClass, function);
        return resultSet -> this.fillFieldValue(clazz, (ResultSet)resultSet);
    }

    public <T> List<T> queryList(String sql, Class<T> clazz) throws Exception {
        return this.queryList(sql, clazz, null, null);
    }

    public <T> T queryOne(String sql, Class<T> clazz) throws Exception {
        return this.queryOne(sql, clazz, null, null);
    }

    public <T> T fillFieldValue(Class<T> clazz, ResultSet resultSet) {
        try {
            T target = clazz.newInstance();
            TargetInfo targetInfo = this.targetInfoCache.get(clazz);
            for (TargetInfo.TargetFieldInfo targetFieldInfo : targetInfo.targetFieldInfoList) {
                Object object = this.getObject(resultSet, targetFieldInfo);
                if (!Objects.nonNull(object)) continue;
                boolean accessible = targetFieldInfo.field.isAccessible();
                targetFieldInfo.field.setAccessible(true);
                targetFieldInfo.field.set(target, object);
                targetFieldInfo.field.setAccessible(accessible);
            }
            return target;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getObject(ResultSet resultSet, TargetInfo.TargetFieldInfo targetFieldInfo) throws SQLException {
        Comparable<Date> object;
        String fieldTypeName = targetFieldInfo.fieldType.getName();
        String columnLabel = targetFieldInfo.columnLabel;
        if (Objects.isNull(columnLabel)) {
            return null;
        }
        switch (fieldTypeName) {
            case "java.util.Date": {
                object = resultSet.getTimestamp(targetFieldInfo.columnLabel);
                break;
            }
            case "java.lang.Byte": {
                object = resultSet.getByte(targetFieldInfo.columnLabel);
                break;
            }
            case "java.time.LocalDateTime": {
                object = Optional.ofNullable(resultSet.getTimestamp(columnLabel)).map(timestamp -> timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).orElse(null);
                break;
            }
            default: {
                object = resultSet.getObject(columnLabel, targetFieldInfo.fieldType);
            }
        }
        return object;
    }

    public <T> List<T> queryList(String sql, Function<ResultSet, T> function) throws Exception {
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery(sql);
        ArrayList<T> dataList = new ArrayList<T>();
        while (rs.next()) {
            T data = function.apply(rs);
            dataList.add(data);
        }
        rs.close();
        statement.close();
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T queryOne(String sql, Function<ResultSet, T> function) throws Exception {
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery(sql);
        try {
            rs.next();
            T t = function.apply(rs);
            return t;
        }
        finally {
            rs.close();
            statement.close();
            this.connection.close();
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    private DataSourceTool() {
    }

    private static class TargetInfo<T, A extends Annotation> {
        Class<T> clazz;
        List<TargetFieldInfo> targetFieldInfoList;

        public TargetInfo(Class<T> clazz, Class<A> annotationClass, Function<A, String> function) {
            Field[] declaredFields;
            this.clazz = clazz;
            this.targetFieldInfoList = new ArrayList<TargetFieldInfo>();
            for (Field declaredField : declaredFields = FieldUtils.getAllFields(clazz)) {
                this.addTargetFieldInfo(declaredField, annotationClass, function);
            }
        }

        public TargetInfo<T, A> addTargetFieldInfo(Field field, Class<A> clazz, Function<A, String> function) {
            TargetFieldInfo<Object> fieldInfo = Objects.isNull(clazz) || Objects.isNull(function) ? new TargetFieldInfo<Column>(field, Column.class, Column::name) : new TargetFieldInfo<A>(field, clazz, function);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, DataColumn.class, DataColumn::value);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, DataTable.class, DataTable::value);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, Table.class, Table::name);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, Column.class, Column::name);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, TableId.class, TableId::value);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, TableField.class, TableField::value);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, DataColumn.class, DataColumn::value);
            ((TargetFieldInfo)fieldInfo).fillColumnLabel(field, DataColumn.class, DataColumn::value);
            this.targetFieldInfoList.add(fieldInfo);
            return this;
        }

        private static class TargetFieldInfo<A extends Annotation> {
            private Field field;
            private Class<?> fieldType;
            private String columnLabel;

            public TargetFieldInfo(Field field, Class<A> annotationClass, Function<A, String> function) {
                this.field = field;
                this.fieldType = field.getType();
                this.fillColumnLabel(field, annotationClass, function);
            }

            private <A> void fillColumnLabel(Field field, Class<A> annotationClass, Function<A, String> function) {
                if (Objects.nonNull(this.columnLabel) || Objects.isNull(field.getAnnotations()) || field.getAnnotations().length == 0) {
                    return;
                }
                Annotation[] annotations = field.getAnnotations();
                Map annotationMap = Arrays.stream(annotations).collect(Collectors.toMap(Annotation::annotationType, Function.identity()));
                if (annotationMap.containsKey(annotationClass)) {
                    Object annotation = annotationMap.get(annotationClass);
                    this.columnLabel = function.apply(annotation);
                }
            }
        }
    }
}

