/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.model.vo;

import cn.woodwhales.common.model.enums.RespCodeEnum;
import cn.woodwhales.common.model.result.BaseRespResult;
import cn.woodwhales.common.model.vo.RespVO;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class PageRespVO<T>
extends RespVO<List<T>> {
    private Long count;

    public static <T> PageRespVO<T> success(Long count, List<T> data) {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, count, data);
    }

    public static <T> PageRespVO<T> success(List<T> data) {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, Long.parseLong(data.size() + ""), data);
    }

    public static <T> PageRespVO<T> empty() {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, 0L, null);
    }

    public static PageRespVO error(BaseRespResult baseRespResult) {
        return PageRespVO.buildPageRespVO(baseRespResult, 0L, null);
    }

    public static <T> PageRespVO<T> buildPageRespVO(IPage<T> page) {
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), page.getRecords());
    }

    public static <S, T> PageRespVO<T> buildPageRespVO(IPage<S> page, Function<? super S, ? extends T> mapper) {
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), Collections.emptyList());
        }
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), page.getRecords().stream().map(mapper).collect(Collectors.toList()));
    }

    public static <S, T> PageRespVO<T> buildPageRespVO(IPage<S> page, Function<? super S, ? extends T> mapper, Comparator<T> comparator) {
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), Collections.emptyList());
        }
        return PageRespVO.buildPageRespVO(RespCodeEnum.SUCCESS, page.getTotal(), page.getRecords().stream().map(mapper).sorted(comparator).collect(Collectors.toList()));
    }

    public static <T> PageRespVO<T> buildPageRespVO(@NotNull BaseRespResult baseRespResult, Long count, List<T> data) {
        Objects.requireNonNull(baseRespResult, "baseRespResult\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        return PageRespVO.build(baseRespResult.getCode(), baseRespResult.getMessage(), count, data);
    }

    private static <T> PageRespVO<T> build(Integer code, String message, Long count, List<T> data) {
        Objects.requireNonNull(code, "code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        PageRespVO<List<T>> pageRespVO = new PageRespVO<List<T>>();
        pageRespVO.setCode(code);
        pageRespVO.setMsg(message);
        if (CollectionUtils.isEmpty(data)) {
            pageRespVO.setCount(0L);
            pageRespVO.setData(Collections.emptyList());
        } else {
            pageRespVO.setCount(count);
            pageRespVO.setData(data);
        }
        return pageRespVO;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRespVO)) {
            return false;
        }
        PageRespVO other = (PageRespVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        return !(this$count == null ? other$count != null : !((Object)this$count).equals(other$count));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageRespVO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PageRespVO(count=" + this.getCount() + ")";
    }
}

