/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.example.webhook;

import cn.woodwhales.common.webhook.enums.WebhookProductEnum;
import cn.woodwhales.common.webhook.executor.WebhookExecutorFactory;
import cn.woodwhales.common.webhook.model.WebhookGlobalInfo;
import cn.woodwhales.common.webhook.model.request.BaseWebhookRequestBody;
import cn.woodwhales.common.webhook.model.request.WebhookRequestBodyFactory;

public class WebhookExecutorTest {
    public static void main(String[] args) {
        WebhookExecutorTest.DingTalkExecutor();
        WebhookExecutorTest.FeiShuExecutor();
        WebhookExecutorTest.WeComExecutor();
    }

    public static void DingTalkExecutor() {
        String url = "https://oapi.dingtalk.com/robot/send?access_token=xxx";
        BaseWebhookRequestBody requestBody = WebhookRequestBodyFactory.newInstance(WebhookProductEnum.DING_TALK, "test title");
        requestBody.addContent("key1\uff1a", "value1");
        requestBody.addContent("key2\uff1a", "value2");
        requestBody.addContent("key3\uff1a", "value3");
        WebhookGlobalInfo globalInfo = new WebhookGlobalInfo(WebhookProductEnum.DING_TALK, new NullPointerException("\u62a5\u9519\u5566"), "cn.woodwhales.webhook");
        requestBody.addGlobalInfo(globalInfo);
        WebhookExecutorFactory.execute(url, requestBody);
    }

    public static void FeiShuExecutor() {
        String url = "https://open.feishu.cn/open-apis/bot/v2/hook/xxx";
        BaseWebhookRequestBody requestBody = WebhookRequestBodyFactory.newInstance(WebhookProductEnum.FEI_SHU, "test title");
        requestBody.addContent("key1\uff1a", "value1");
        requestBody.addContent("key2\uff1a", "value2");
        requestBody.addContent("key3\uff1a", "value3");
        WebhookGlobalInfo globalInfo = new WebhookGlobalInfo(WebhookProductEnum.FEI_SHU, new NullPointerException("\u62a5\u9519\u5566"), "cn.woodwhales.webhook");
        requestBody.addGlobalInfo(globalInfo);
        WebhookExecutorFactory.execute(url, requestBody);
    }

    public static void WeComExecutor() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=xxx";
        WebhookExecutorFactory.execute(WebhookProductEnum.WE_COM, url, "test title", req -> {
            req.addContent("key1\uff1a", "value1");
            req.addContent("key2\uff1a", "value2");
            req.addContent("key3\uff1a", "value3");
            WebhookGlobalInfo globalInfo = new WebhookGlobalInfo(WebhookProductEnum.WE_COM, new NullPointerException("\u62a5\u9519\u5566"), "cn.woodwhales.webhook");
            req.addGlobalInfo(globalInfo);
        });
    }
}

